/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.flow.condition.bool.AbstractMultiCondition;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class And
extends AbstractMultiCondition {
    private static final long serialVersionUID = 6011135059965158475L;

    @Override
    public String globalInfo() {
        return "Performs a logical AND over all its sub-conditions, i.e., it only evaluates to 'true' if all of the sub-conditions evaluate to 'true' as well.";
    }

    @Override
    public String conditionsTipText() {
        return "The conditions to use for the logical AND.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        boolean result = true;
        for (BooleanCondition condition : this.m_Conditions) {
            if (condition.evaluate(owner, token)) continue;
            result = false;
            break;
        }
        return result;
    }
}

