/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class Counting
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 8559824356449366329L;
    protected int m_Minimum;
    protected int m_Maximum;
    protected int m_Interval;
    protected int m_Current;

    @Override
    public String globalInfo() {
        return "Counts the tokens passing through and returns 'true' if min/max/interval are met.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min", "minimum", -1, -1, null);
        this.m_OptionManager.add("max", "maximum", -1, -1, null);
        this.m_OptionManager.add("interval", "interval", -1, -1, null);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Current = 0;
    }

    protected int getCurrent() {
        return this.m_Current;
    }

    public void setMinimum(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_Minimum = value;
        this.reset();
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum number of tokens to count before activating (-1 to disable).";
    }

    public void setMaximum(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_Maximum = value;
        this.reset();
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum number of tokens to count before de-activating (-1 to disable).";
    }

    public void setInterval(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The number of tokens (or multiples) to count before teeing-off the input token.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "minimum", this.m_Minimum, "min=");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "maximum", this.m_Maximum, ", max=");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "interval", this.m_Interval, ", interval=");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        ++this.m_Current;
        boolean result = true;
        if (result && this.getMinimum() > -1 && this.getCurrent() < this.getMinimum()) {
            result = false;
        }
        if (result && this.getMaximum() > -1 && this.getCurrent() > this.getMaximum()) {
            result = false;
        }
        if (result && this.getInterval() > -1 && this.getCurrent() % this.getInterval() != 0) {
            result = false;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("current=" + this.getCurrent() + ", min=" + this.getMinimum() + ", max=" + this.getMaximum() + ", interval=" + this.getInterval() + ": " + result);
        }
        return result;
    }
}

