/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.control.Flow;
import adams.flow.core.ActorPath;
import adams.flow.core.ControlActor;
import adams.flow.core.Unknown;
import adams.flow.execution.PathBreakpoint;
import adams.flow.execution.debug.View;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.tools.ExpressionWatchPanel;

public class Breakpoint
extends AbstractTransformer
implements ControlActor,
BooleanConditionSupporter {
    private static final long serialVersionUID = 1670185555433805533L;
    protected boolean m_OnPreInput;
    protected boolean m_OnPostInput;
    protected boolean m_OnPreExecute;
    protected boolean m_OnPostExecute;
    protected boolean m_OnPreOutput;
    protected boolean m_OnPostOutput;
    protected BooleanCondition m_Condition;
    protected View[] m_Views;
    protected BaseString[] m_Watches;
    protected ExpressionWatchPanel.ExpressionType[] m_WatchTypes;

    @Override
    public String globalInfo() {
        return "Allows to pause the execution of the flow when this actor is reached and the condition evaluates to 'true'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("on-pre-input", "onPreInput", false);
        this.m_OptionManager.add("on-post-input", "onPostInput", false);
        this.m_OptionManager.add("on-pre-execute", "onPreExecute", true);
        this.m_OptionManager.add("on-post-execute", "onPostExecute", false);
        this.m_OptionManager.add("on-pre-output", "onPreOutput", false);
        this.m_OptionManager.add("on-post-output", "onPostOutput", false);
        this.m_OptionManager.add("condition", "condition", new Expression());
        this.m_OptionManager.add("watch", "watches", new BaseString[0]);
        this.m_OptionManager.add("watch-type", "watchTypes", new ExpressionWatchPanel.ExpressionType[0]);
        this.m_OptionManager.add("view", "views", new View[0]);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "condition", this.m_Condition.getQuickInfo());
    }

    public void setOnPreInput(boolean value) {
        this.m_OnPreInput = value;
        this.reset();
    }

    public boolean getOnPreInput() {
        return this.m_OnPreInput;
    }

    public String onPreInputTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-input (of token) time; token available.";
    }

    public void setOnPostInput(boolean value) {
        this.m_OnPostInput = value;
        this.reset();
    }

    public boolean getOnPostInput() {
        return this.m_OnPostInput;
    }

    public String onPostInputTipText() {
        return "If set to true, the breakpoint gets evaluated at post-input (of token) time.";
    }

    public void setOnPreExecute(boolean value) {
        this.m_OnPreExecute = value;
        this.reset();
    }

    public boolean getOnPreExecute() {
        return this.m_OnPreExecute;
    }

    public String onPreExecuteTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-execute time.";
    }

    public void setOnPostExecute(boolean value) {
        this.m_OnPostExecute = value;
        this.reset();
    }

    public boolean getOnPostExecute() {
        return this.m_OnPostExecute;
    }

    public String onPostExecuteTipText() {
        return "If set to true, the breakpoint gets evaluated at post-execute time.";
    }

    public void setOnPreOutput(boolean value) {
        this.m_OnPreOutput = value;
        this.reset();
    }

    public boolean getOnPreOutput() {
        return this.m_OnPreOutput;
    }

    public String onPreOutputTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-output (of token) time; token available.";
    }

    public void setOnPostOutput(boolean value) {
        this.m_OnPostOutput = value;
        this.reset();
    }

    public boolean getOnPostOutput() {
        return this.m_OnPostOutput;
    }

    public String onPostOutputTipText() {
        return "If set to true, the breakpoint gets evaluated at post-output (of token) time.";
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition to evaluate; if the condition evaluates to 'true', the execution of the flow is paused.";
    }

    public void setWatches(BaseString[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!Variables.isPlaceholder(value[i].getValue())) continue;
            value[i] = new BaseString("(" + value[i].getValue() + ")");
        }
        this.m_Watches = value;
        this.reset();
    }

    public BaseString[] getWatches() {
        return this.m_Watches;
    }

    public String watchesTipText() {
        return "The expression to display initially in the watch dialog; the type of the watch needs to be specified as well.";
    }

    public void setWatchTypes(ExpressionWatchPanel.ExpressionType[] value) {
        this.m_WatchTypes = value;
        this.reset();
    }

    public ExpressionWatchPanel.ExpressionType[] getWatchTypes() {
        return this.m_WatchTypes;
    }

    public String watchTypesTipText() {
        return "The types of the watch expressions; determines how the expressions get evaluated and displayed.";
    }

    public void setViews(View[] value) {
        this.m_Views = value;
        this.reset();
    }

    public View[] getViews() {
        return this.m_Views;
    }

    public String viewsTipText() {
        return "The views to display automatically when the breakpoint is reached.";
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.getRoot() instanceof Flow) {
                Flow flow = (Flow)this.getRoot();
                PathBreakpoint breakpoint = new PathBreakpoint();
                breakpoint.setOnPreInput(this.m_OnPreInput);
                breakpoint.setOnPostInput(this.m_OnPostInput);
                breakpoint.setOnPreExecute(this.m_OnPreExecute);
                breakpoint.setOnPostExecute(this.m_OnPostExecute);
                breakpoint.setOnPreOutput(this.m_OnPreOutput);
                breakpoint.setOnPostOutput(this.m_OnPostOutput);
                breakpoint.setCondition(this.getCondition());
                breakpoint.setViews((View[])this.m_Views.clone());
                breakpoint.setWatches((BaseString[])this.m_Watches.clone());
                breakpoint.setWatchTypes((ExpressionWatchPanel.ExpressionType[])this.m_WatchTypes.clone());
                breakpoint.setPath(new ActorPath(this.getFullName()));
                flow.addBreakpoint(breakpoint);
            } else {
                result = "Root actor is not a flow, failed to set breakpoint!";
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        this.m_OutputToken = this.m_InputToken;
        return null;
    }
}

