/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.DefaultFilenameGenerator;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.ControlActor;
import adams.flow.core.DataPlotUpdaterHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.ComponentSupplier;
import adams.gui.print.JComponentWriter;
import adams.gui.print.NullWriter;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CallableActorScreenshot
extends AbstractActor
implements ControlActor,
InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -7346814880631564292L;
    public static final String BACKUP_COUNTER = "counter";
    public static final String BACKUP_INPUT = "input";
    protected CallableActorReference m_CallableName;
    protected Token m_InputToken;
    protected Token m_OutputToken;
    protected JComponentWriter m_Writer;
    protected AbstractFilenameGenerator m_FilenameGenerator;
    protected CallableActorHelper m_Helper;
    protected AbstractActor m_CallableActor;
    protected int m_Counter;
    protected String m_ScreenshotResult;

    @Override
    public String globalInfo() {
        return "Takes a screenshot of a callable actor whenever a token passes through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", new CallableActorReference("unknown"));
        this.m_OptionManager.add("filename-generator", "filenameGenerator", new DefaultFilenameGenerator());
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Counter = 0;
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_COUNTER);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_COUNTER, this.m_Counter);
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_COUNTER)) {
            this.m_Counter = (Integer)state.get(BACKUP_COUNTER);
            state.remove(BACKUP_COUNTER);
        }
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "callableName", this.m_CallableName, "callable: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "filenameGenerator", this.m_FilenameGenerator, ", generator: ");
        return result;
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    public void setFilenameGenerator(AbstractFilenameGenerator value) {
        this.m_FilenameGenerator = value;
        this.reset();
    }

    public AbstractFilenameGenerator getFilenameGenerator() {
        return this.m_FilenameGenerator;
    }

    public String filenameGeneratorTipText() {
        return "The filename generator to use.";
    }

    public void setWriter(JComponentWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public JComponentWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for generating the graphics output.";
    }

    protected AbstractActor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive(this, this.getCallableName());
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_CallableActor = this.findCallableActor();
            if (this.m_CallableActor == null) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else if (!(this.m_CallableActor instanceof ComponentSupplier)) {
                result = "Callable actor '" + this.getCallableName() + "' is not a " + ComponentSupplier.class.getName() + "!";
            } else {
                HashSet<String> variables = this.findVariables(this.m_CallableActor);
                this.m_DetectedVariables.addAll(variables);
                if (this.m_DetectedVariables.size() > 0) {
                    this.getVariables().addVariableChangeListener(this);
                }
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        this.m_OutputToken = null;
    }

    @Override
    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    @Override
    public Token currentInput() {
        return this.m_InputToken;
    }

    protected PlaceholderFile generateFilename() {
        ++this.m_Counter;
        PlaceholderFile result = new PlaceholderFile(this.m_FilenameGenerator.generate(this.m_Counter));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        if (this.m_Writer instanceof NullWriter) {
            return null;
        }
        this.m_ScreenshotResult = null;
        final PlaceholderFile filename = this.generateFilename();
        if (!this.isHeadless()) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractActor abstractActor = CallableActorScreenshot.this.m_CallableActor;
                    synchronized (abstractActor) {
                        JComponent comp;
                        if (CallableActorScreenshot.this.m_CallableActor instanceof DataPlotUpdaterHandler) {
                            ((DataPlotUpdaterHandler)((Object)CallableActorScreenshot.this.m_CallableActor)).updatePlot();
                        }
                        if ((comp = ((ComponentSupplier)((Object)CallableActorScreenshot.this.m_CallableActor)).supplyComponent()) != null && comp.getWidth() > 0 && comp.getHeight() > 0) {
                            CallableActorScreenshot.this.getLogger().info("Saving to: " + filename);
                            CallableActorScreenshot.this.m_Writer.setComponent(((ComponentSupplier)((Object)CallableActorScreenshot.this.m_CallableActor)).supplyComponent());
                            CallableActorScreenshot.this.m_Writer.setFile(filename);
                            try {
                                CallableActorScreenshot.this.m_Writer.toOutput();
                            }
                            catch (Exception e) {
                                CallableActorScreenshot.this.m_ScreenshotResult = CallableActorScreenshot.this.handleException("Failed to generate screenshot ('" + filename + "'): ", e);
                            }
                            CallableActorScreenshot.this.m_Writer.setComponent(null);
                        }
                        AbstractActor abstractActor2 = CallableActorScreenshot.this.m_Self;
                        synchronized (abstractActor2) {
                            try {
                                CallableActorScreenshot.this.m_Self.notifyAll();
                            }
                            catch (Exception e) {
                                CallableActorScreenshot.this.handleException("Failed to notify all", e);
                            }
                        }
                    }
                }
            };
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                SwingUtilities.invokeLater(run);
                try {
                    this.m_Self.wait();
                }
                catch (Exception e) {
                    this.handleException("Failed to wait", e);
                }
            }
        }
        String result = this.m_ScreenshotResult;
        this.m_ScreenshotResult = null;
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public String execute() {
        String result = super.execute();
        if (this.m_Skip) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

