/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractPropertyUpdater;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.PropertyHelper;
import adams.gui.goe.PropertyPath;

public abstract class AbstractCallableActorPropertyUpdater
extends AbstractPropertyUpdater {
    private static final long serialVersionUID = 8068932300654252910L;
    protected CallableActorReference m_ActorName;
    protected transient AbstractActor m_CallableActor;
    protected transient PropertyPath.PropertyContainer m_Container;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor-name", "actorName", new CallableActorReference("unknown"));
    }

    public void setActorName(CallableActorReference value) {
        this.m_ActorName = value;
        this.reset();
    }

    public CallableActorReference getActorName() {
        return this.m_ActorName;
    }

    public String actorNameTipText() {
        return "The name of the callable actor to update the property for.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "actorName", this.m_ActorName, ", name: ");
        return result;
    }

    @Override
    protected void updateProperty(String s) {
        Object value = PropertyHelper.convertValue(this.m_Container, s);
        if (value != null) {
            PropertyPath.setValue((Object)this.m_CallableActor, this.m_Property, value);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Property '" + this.m_Property + "' of '" + this.m_ActorName + "' changed to: " + value);
            }
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            CallableActorHelper helper = new CallableActorHelper();
            this.m_CallableActor = helper.findCallableActorRecursive(this, this.m_ActorName);
            if (this.m_CallableActor == null) {
                result = "Cannot find callable actor '" + this.m_ActorName + "'!";
            } else {
                this.m_Container = PropertyPath.find((Object)this.m_CallableActor, this.m_Property);
                if (this.m_Container == null) {
                    result = "Cannot find property '" + this.m_Property + "' in callable actor '" + this.m_ActorName + "'!";
                }
            }
        }
        return result;
    }
}

