/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.option.NestedProducer;
import adams.flow.core.RunnableWithLogging;
import adams.flow.execution.AbstractFlowExecutionListener;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;

public class RemoteFlowListener
extends AbstractFlowExecutionListener {
    private static final long serialVersionUID = -4076279129101243861L;
    public static final int DEFAULT_PORT = 12345;
    protected int m_Port;
    protected transient ListenerRunnable m_Runnable;

    @Override
    public String globalInfo() {
        return "Listens on the specified port, returns the currently running flow setup.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("port", "port", 12345, 1, 65535);
    }

    public void setPort(int value) {
        if (value >= 1 && value <= 65535) {
            this.m_Port = value;
            this.reset();
        } else {
            this.getLogger().severe("Port must be 1 <= x <= 65535, provided: " + value);
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to listen on.";
    }

    @Override
    public void startListening() {
        this.m_Runnable = new ListenerRunnable(this);
        new Thread(this.m_Runnable).start();
    }

    @Override
    public void finishListening() {
        this.m_Runnable.stopExecution();
        this.m_Runnable = null;
    }

    public static class ListenerRunnable
    extends RunnableWithLogging {
        private static final long serialVersionUID = -4092874820780532222L;
        protected RemoteFlowListener m_Owner;
        protected ServerSocket m_ServerSocket;

        public ListenerRunnable(RemoteFlowListener owner) {
            this.m_Owner = owner;
            this.setLoggingLevel(this.m_Owner.getLoggingLevel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            this.m_ServerSocket = null;
            try {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Creating server socket on port " + this.m_Owner.getPort());
                }
                this.m_ServerSocket = new ServerSocket(this.m_Owner.getPort());
                while (this.m_Running) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Waiting for connection...");
                    }
                    Socket socket = this.m_ServerSocket.accept();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Accepted connection from: " + socket.getInetAddress() + ":" + socket.getPort());
                    }
                    PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                    NestedProducer producer = new NestedProducer();
                    producer.setOutputClasspath(false);
                    producer.produce(this.m_Owner.getOwner());
                    out.write(producer.toString());
                    out.close();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Sent flow to: " + socket.getInetAddress() + ":" + socket.getPort());
                    }
                    socket.close();
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("Closed socket");
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error while listening!", e);
            }
            finally {
                this.stopExecution();
            }
        }

        @Override
        public void stopExecution() {
            if (this.m_ServerSocket != null) {
                try {
                    this.m_ServerSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.stopExecution();
        }
    }
}

