/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution.debug;

import adams.core.CleanUpHandler;
import adams.core.option.DebugNestedProducer;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.control.Breakpoint;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.AbstractBreakpoint;
import adams.flow.execution.Debug;
import adams.flow.execution.ExecutionStage;
import adams.flow.execution.debug.BreakpointPanel;
import adams.flow.execution.debug.View;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.FlowTreeHandler;
import adams.gui.flow.StoragePanel;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.FlowHelper;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.ExpressionWatchPanel;
import adams.gui.tools.VariableManagementPanel;
import adams.gui.visualization.debug.InspectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanel
extends BasePanel
implements CleanUpHandler,
FlowTreeHandler {
    private static final long serialVersionUID = 1000900663466801934L;
    protected BaseTabbedPane m_TabbedPaneDisplays;
    protected JButton m_ButtonStop;
    protected JButton m_ButtonToggle;
    protected JButton m_ButtonPauseResume;
    protected JButton m_ButtonStep;
    protected JToggleButton m_ButtonExpressions;
    protected JPanel m_PanelCondition;
    protected GenericObjectEditorPanel m_GOEPanelCondition;
    protected JToggleButton m_ButtonSource;
    protected JToggleButton m_ButtonVariables;
    protected JToggleButton m_ButtonStorage;
    protected JToggleButton m_ButtonInspectToken;
    protected JToggleButton m_ButtonBreakpoints;
    protected ExpressionWatchPanel m_PanelExpressions;
    protected VariableManagementPanel m_PanelVariables;
    protected InspectionPanel m_PanelInspectionToken;
    protected TextEditorPanel m_PanelSource;
    protected StoragePanel m_PanelStorage;
    protected BreakpointPanel m_PanelBreakpoints;
    protected JTextField m_TextActorPath;
    protected JToggleButton m_ButtonActorPath;
    protected JTextField m_TextStage;
    protected transient Debug m_Owner;
    protected Token m_CurrentToken;
    protected Actor m_CurrentActor;
    protected ExecutionStage m_CurrentStage;
    protected BooleanCondition m_CurrentCondition;
    protected AbstractBreakpoint m_CurrentBreakpoint;
    protected boolean m_Manual;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Manual = false;
        this.m_CurrentActor = null;
        this.m_CurrentBreakpoint = null;
        this.m_CurrentCondition = null;
        this.m_CurrentStage = null;
        this.m_CurrentToken = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPaneDisplays = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPaneDisplays, "Center");
        JPanel panelAllButtons = new JPanel(new BorderLayout());
        this.add((Component)panelAllButtons, "North");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Execution"));
        panelAllButtons.add((Component)panel, "North");
        JPanel panelButtons = new JPanel(new GridLayout(1, 4));
        panel.add((Component)panelButtons, "North");
        this.m_ButtonPauseResume = new JButton("Resume", GUIHelper.getIcon("resume.gif"));
        this.m_ButtonPauseResume.setToolTipText("Pause/Resume execution");
        this.m_ButtonPauseResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.pauseResumeExecution();
            }
        });
        panelButtons.add(this.m_ButtonPauseResume);
        this.m_ButtonStep = new JButton("Step", GUIHelper.getIcon("step.gif"));
        this.m_ButtonStep.setMnemonic('e');
        this.m_ButtonStep.setToolTipText("Step to next actor");
        this.m_ButtonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.nextStep();
            }
        });
        panelButtons.add(this.m_ButtonStep);
        this.m_ButtonToggle = new JButton("Disable", GUIHelper.getIcon("debug_off.png"));
        this.m_ButtonToggle.setMnemonic('D');
        this.m_ButtonToggle.setToolTipText("Disable the breakpoint");
        this.m_ButtonToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.disableEnableBreakpoint();
            }
        });
        panelButtons.add(this.m_ButtonToggle);
        this.m_ButtonStop = new JButton("Stop", GUIHelper.getIcon("stop.gif"));
        this.m_ButtonStop.setMnemonic('S');
        this.m_ButtonStop.setToolTipText("Stops the flow execution immediately");
        this.m_ButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.stopFlowExecution();
            }
        });
        panelButtons.add(this.m_ButtonStop);
        this.m_PanelCondition = new JPanel(new FlowLayout(0));
        panel.add((Component)this.m_PanelCondition, "Center");
        this.m_GOEPanelCondition = new GenericObjectEditorPanel(BooleanCondition.class, new Breakpoint().getCondition(), false);
        this.m_GOEPanelCondition.setEditable(false);
        this.m_GOEPanelCondition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControlPanel.this.update();
            }
        });
        this.m_PanelCondition.add(new JLabel("Condition"));
        this.m_PanelCondition.add(this.m_GOEPanelCondition);
        panelButtons = new JPanel(new GridLayout(2, 3));
        panelButtons.setBorder(BorderFactory.createTitledBorder("Runtime information"));
        panel = new JPanel(new BorderLayout());
        panel.add((Component)panelButtons, "North");
        panelAllButtons.add((Component)panel, "Center");
        this.m_ButtonExpressions = new JToggleButton("Expressions", GUIHelper.getIcon("glasses.gif"));
        this.m_ButtonExpressions.setMnemonic('x');
        this.m_ButtonExpressions.setToolTipText("Display dialog for watch expressions");
        this.m_ButtonExpressions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.m_Manual = true;
                ControlPanel.this.showWatchExpressions(ControlPanel.this.m_ButtonExpressions.isSelected());
            }
        });
        panelButtons.add(this.m_ButtonExpressions);
        this.m_ButtonVariables = new JToggleButton("Variables", GUIHelper.getIcon("variable.gif"));
        this.m_ButtonVariables.setMnemonic('V');
        this.m_ButtonVariables.setToolTipText("Display dialog with currently active variables");
        this.m_ButtonVariables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.m_Manual = true;
                ControlPanel.this.showVariables(ControlPanel.this.m_ButtonVariables.isSelected());
            }
        });
        panelButtons.add(this.m_ButtonVariables);
        this.m_ButtonStorage = new JToggleButton("Storage", GUIHelper.getIcon("disk.png"));
        this.m_ButtonStorage.setMnemonic('t');
        this.m_ButtonStorage.setToolTipText("Display dialog with items currently stored in temporary storage");
        this.m_ButtonStorage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.m_Manual = true;
                ControlPanel.this.showStorage(ControlPanel.this.m_ButtonStorage.isSelected());
            }
        });
        panelButtons.add(this.m_ButtonStorage);
        this.m_ButtonInspectToken = new JToggleButton("Inspect token", GUIHelper.getIcon("properties.gif"));
        this.m_ButtonInspectToken.setMnemonic('I');
        this.m_ButtonInspectToken.setToolTipText("Display dialog for inspecting the current token");
        this.m_ButtonInspectToken.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.m_Manual = true;
                ControlPanel.this.inspectToken(ControlPanel.this.m_ButtonInspectToken.isSelected());
            }
        });
        panelButtons.add(this.m_ButtonInspectToken);
        this.m_ButtonBreakpoints = new JToggleButton("Breakpoints", GUIHelper.getIcon("flow.gif"));
        this.m_ButtonBreakpoints.setMnemonic('n');
        this.m_ButtonBreakpoints.setToolTipText("Display dialog for inspecting the current flow");
        this.m_ButtonBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.m_Manual = true;
                ControlPanel.this.showBreakpoints(ControlPanel.this.m_ButtonBreakpoints.isSelected());
            }
        });
        panelButtons.add(this.m_ButtonBreakpoints);
        this.m_ButtonSource = new JToggleButton("Source", GUIHelper.getIcon("source.png"));
        this.m_ButtonSource.setMnemonic('o');
        this.m_ButtonSource.setToolTipText("Display current flow state as source (nested format)");
        this.m_ButtonSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.m_Manual = true;
                ControlPanel.this.showSource(ControlPanel.this.m_ButtonSource.isSelected());
            }
        });
        panelButtons.add(this.m_ButtonSource);
        panel = new JPanel(new FlowLayout(0));
        this.m_TextActorPath = new JTextField(30);
        this.m_TextActorPath.setEditable(false);
        this.m_ButtonActorPath = new JToggleButton(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonActorPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(ControlPanel.this.m_TextActorPath.getText());
            }
        });
        this.m_TextStage = new JTextField(15);
        this.m_TextStage.setEditable(false);
        panel.add(new JLabel("Actor path"));
        panel.add(this.m_TextActorPath);
        panel.add(this.m_ButtonActorPath);
        panel.add(this.m_TextStage);
        panelAllButtons.add((Component)panel, "South");
        this.m_PanelExpressions = new ExpressionWatchPanel();
        this.m_PanelBreakpoints = new BreakpointPanel();
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    protected Flow getFlow() {
        return (Flow)this.m_CurrentActor.getRoot();
    }

    public void update() {
        this.update(this.getOwner() != null && this.getOwner().isBlocked());
    }

    public void update(boolean blocked) {
        boolean actorPresent = this.getCurrentActor() != null;
        boolean stopped = actorPresent && this.getFlow().isStopped();
        boolean hasToken = this.getCurrentToken() != null;
        this.m_ButtonStop.setEnabled(actorPresent && !stopped);
        this.m_ButtonToggle.setEnabled(actorPresent && !stopped && this.m_CurrentBreakpoint != null);
        this.m_ButtonPauseResume.setEnabled(actorPresent && !stopped);
        this.m_ButtonStep.setEnabled(actorPresent && !stopped && blocked);
        this.m_ButtonVariables.setEnabled(actorPresent);
        this.m_ButtonStorage.setEnabled(actorPresent);
        this.m_ButtonExpressions.setEnabled(actorPresent && !stopped && blocked);
        this.m_ButtonBreakpoints.setEnabled(actorPresent && !stopped && blocked);
        this.m_ButtonInspectToken.setEnabled(actorPresent && !stopped && blocked && hasToken);
        this.m_ButtonSource.setEnabled(actorPresent && !stopped && blocked);
        this.m_PanelCondition.setEnabled(actorPresent && !stopped && blocked);
        this.m_GOEPanelCondition.setEnabled(this.m_PanelCondition.isEnabled());
        this.m_ButtonActorPath.setEnabled(this.m_TextActorPath.getText().length() > 0);
        if (!this.m_ButtonInspectToken.isEnabled()) {
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken.setCurrent(null);
            }
        } else if (this.m_PanelInspectionToken != null) {
            this.m_PanelInspectionToken.setCurrent(this.getCurrentToken());
        }
        if (this.getCurrentBreakpoint() != null) {
            if (this.getCurrentBreakpoint().getDisabled()) {
                this.m_ButtonToggle.setText("Enable");
                this.m_ButtonToggle.setMnemonic('E');
                this.m_ButtonToggle.setToolTipText("Enable current breakpoint");
                this.m_ButtonToggle.setIcon(GUIHelper.getIcon("debug.png"));
            } else {
                this.m_ButtonToggle.setText("Disable");
                this.m_ButtonToggle.setMnemonic('D');
                this.m_ButtonToggle.setToolTipText("Disable current breakpoint");
                this.m_ButtonToggle.setIcon(GUIHelper.getIcon("debug_off.png"));
            }
        }
        if (this.m_Owner != null) {
            if (this.m_Owner.isBlocked() || this.m_Owner.isStepMode()) {
                this.m_ButtonPauseResume.setText("Resume");
                this.m_ButtonPauseResume.setMnemonic('R');
                this.m_ButtonPauseResume.setIcon(GUIHelper.getIcon("resume.gif"));
            } else {
                this.m_ButtonPauseResume.setText("Pause");
                this.m_ButtonPauseResume.setMnemonic('P');
                this.m_ButtonPauseResume.setIcon(GUIHelper.getIcon("pause.gif"));
            }
            this.m_PanelBreakpoints.setIgnoreUpdates(true);
            this.m_PanelBreakpoints.setOwner(this);
            this.m_PanelBreakpoints.setIgnoreUpdates(false);
        }
    }

    public void queueUpdate() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ControlPanel.this.update();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void setOwner(Debug value) {
        this.m_Owner = value;
    }

    public Debug getOwner() {
        return this.m_Owner;
    }

    public void setCurrentToken(Token value) {
        this.m_CurrentToken = value;
    }

    public Token getCurrentToken() {
        return this.m_CurrentToken;
    }

    public void setCurrentActor(Actor value) {
        this.m_CurrentActor = value;
    }

    public Actor getCurrentActor() {
        return this.m_CurrentActor;
    }

    public void setCurrentStage(ExecutionStage value) {
        this.m_CurrentStage = value;
    }

    public ExecutionStage getCurrentStage() {
        return this.m_CurrentStage;
    }

    public void setCurrentCondition(BooleanCondition value) {
        this.m_CurrentCondition = value;
    }

    public BooleanCondition getCurrentCondition() {
        return this.m_CurrentCondition;
    }

    public void setCurrentBreakpoint(AbstractBreakpoint value) {
        this.m_CurrentBreakpoint = value;
    }

    public AbstractBreakpoint getCurrentBreakpoint() {
        return this.m_CurrentBreakpoint;
    }

    @Override
    public Tree getTree() {
        Tree result = null;
        if (this.getCurrentActor().getRoot() instanceof Flow) {
            Flow flow = (Flow)this.getCurrentActor().getRoot();
            if (flow.isHeadless()) {
                return result;
            }
            if (flow.getParentComponent() != null) {
                if (flow.getParentComponent() instanceof FlowPanel) {
                    result = ((FlowPanel)flow.getParentComponent()).getTree();
                } else if (flow.getParentComponent() instanceof Container) {
                    result = FlowHelper.getTree((Container)flow.getParentComponent());
                } else if (flow.getParentComponent() instanceof FlowTreeHandler) {
                    result = ((FlowTreeHandler)((Object)flow.getParentComponent())).getTree();
                }
            }
        }
        return result;
    }

    protected void continueFlowExecution() {
        this.getOwner().unblockExecution();
        this.queueUpdate();
    }

    protected void stopFlowExecution() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
        this.getFlow().stopExecution("User stopped flow!");
        this.getOwner().unblockExecution();
    }

    public void setStepModeEnabled(boolean enabled) {
        if (this.m_PanelBreakpoints != null) {
            this.m_PanelBreakpoints.setStepModeEnabled(enabled);
        }
    }

    public boolean isStepModeEnabled() {
        if (this.m_PanelBreakpoints != null) {
            return this.m_PanelBreakpoints.isStepModeEnabled();
        }
        return false;
    }

    protected void disableEnableBreakpoint() {
        if (this.getCurrentBreakpoint() == null) {
            return;
        }
        this.getCurrentBreakpoint().setDisabled(!this.getCurrentBreakpoint().getDisabled());
        this.queueUpdate();
    }

    protected void pauseResumeExecution() {
        this.m_Owner.setStepMode(false);
        if (this.getOwner().isBlocked()) {
            this.continueFlowExecution();
        }
        this.queueUpdate();
    }

    protected void nextStep() {
        this.getOwner().setStepMode(true);
        if (this.getOwner().isBlocked()) {
            this.continueFlowExecution();
        }
        this.queueUpdate();
    }

    protected void setPanelVisible(JPanel panel, String title, boolean visible) {
        int present = -1;
        for (int i = 0; i < this.m_TabbedPaneDisplays.getTabCount(); ++i) {
            if (this.m_TabbedPaneDisplays.getComponentAt(i) != panel) continue;
            present = i;
            break;
        }
        if (visible && present > -1 || !visible && present == -1) {
            return;
        }
        if (visible) {
            this.m_TabbedPaneDisplays.addTab(title, panel);
            this.m_TabbedPaneDisplays.setSelectedIndex(this.m_TabbedPaneDisplays.getTabCount() - 1);
        } else {
            this.m_TabbedPaneDisplays.remove(present);
        }
    }

    protected void showWatchExpressions(boolean visible) {
        this.m_PanelExpressions.setVariables(this.getCurrentActor().getVariables());
        this.setPanelVisible(this.m_PanelExpressions, "Expressions", visible);
    }

    protected void showSource(boolean visible) {
        String content;
        if (this.m_PanelSource == null) {
            this.m_PanelSource = new TextEditorPanel();
            this.m_PanelSource.setTextFont(GUIHelper.getMonospacedFont());
            this.m_PanelSource.setEditable(false);
            this.m_PanelSource.setTabSize(2);
        }
        if (visible) {
            DebugNestedProducer producer = new DebugNestedProducer();
            producer.produce(this.getFlow());
            content = producer.toString();
            producer.cleanUp();
        } else {
            content = "";
        }
        this.m_PanelSource.setContent(content);
        this.setPanelVisible(this.m_PanelSource, "Source", visible);
    }

    protected void showVariables(boolean visible) {
        if (this.m_PanelVariables == null) {
            this.m_PanelVariables = new VariableManagementPanel();
        }
        this.m_PanelVariables.setVariables(this.getCurrentActor().getVariables());
        this.setPanelVisible(this.m_PanelVariables, "Variables", visible);
    }

    protected void inspectToken(boolean visible) {
        if (!visible) {
            this.m_ButtonInspectToken.setSelected(false);
        }
        if (this.m_PanelInspectionToken == null) {
            this.m_PanelInspectionToken = new InspectionPanel();
        }
        this.m_PanelInspectionToken.setCurrent(this.m_CurrentToken);
        this.setPanelVisible(this.m_PanelInspectionToken, "Token", visible);
    }

    protected void showBreakpoints(boolean visible) {
        if (this.m_PanelBreakpoints == null) {
            this.m_PanelBreakpoints = new BreakpointPanel();
            this.m_PanelBreakpoints.setOwner(this);
        }
        this.m_PanelBreakpoints.refresh();
        this.setPanelVisible(this.m_PanelBreakpoints, "Breakpoints", visible);
    }

    protected void showStorage(boolean visible) {
        if (this.m_PanelStorage == null) {
            this.m_PanelStorage = new StoragePanel();
        }
        this.setPanelVisible(this.m_PanelStorage, "Storage", visible);
        this.m_PanelStorage.setHandler(this.getCurrentActor().getStorageHandler());
    }

    public void showFrame() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(true);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(true);
        }
    }

    protected void highlightActor() {
        if (this.getFlow().getParentComponent() == null) {
            return;
        }
        Component comp = this.getFlow().getParentComponent();
        if (!(comp instanceof FlowPanel)) {
            return;
        }
        final Tree tree = ((FlowPanel)comp).getTree();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String full = ControlPanel.this.m_CurrentActor.getFullName();
                tree.locateAndDisplay(full);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void breakpointReached(boolean blocked) {
        this.m_TextActorPath.setText(this.getCurrentActor().getFullName());
        this.m_TextStage.setText(this.getCurrentStage().toDisplay());
        if (this.getCurrentCondition() == null) {
            this.m_PanelCondition.setEnabled(false);
            this.m_GOEPanelCondition.setEnabled(false);
        } else {
            this.m_PanelCondition.setEnabled(true);
            this.m_GOEPanelCondition.setEnabled(true);
            this.m_GOEPanelCondition.setCurrent(this.getCurrentCondition().shallowCopy());
        }
        if (this.getCurrentBreakpoint() != null) {
            for (int i = 0; i < this.getCurrentBreakpoint().getWatches().length; ++i) {
                this.m_PanelExpressions.addExpression(this.getCurrentBreakpoint().getWatches()[i].getValue(), this.getCurrentBreakpoint().getWatchTypes()[i]);
            }
        }
        this.m_PanelExpressions.refreshAllExpressions();
        if (this.m_PanelStorage != null) {
            this.m_PanelStorage.setHandler(this.getCurrentActor().getStorageHandler());
        }
        this.highlightActor();
        this.update(blocked);
        if (!this.m_Manual) {
            HashSet<View> views = new HashSet<View>(Arrays.asList(this.getOwner().getViews()));
            if (this.getCurrentBreakpoint() != null) {
                views.addAll(Arrays.asList(this.getCurrentBreakpoint().getViews()));
            }
            block9: for (View d : views) {
                switch (d) {
                    case SOURCE: {
                        this.m_ButtonSource.setSelected(true);
                        this.showSource(true);
                        continue block9;
                    }
                    case EXPRESSIONS: {
                        this.m_ButtonExpressions.setSelected(true);
                        this.showWatchExpressions(true);
                        continue block9;
                    }
                    case INSPECT_TOKEN: {
                        this.m_ButtonInspectToken.setSelected(this.getCurrentToken() != null);
                        this.inspectToken(this.getCurrentToken() != null);
                        continue block9;
                    }
                    case STORAGE: {
                        this.m_ButtonStorage.setSelected(true);
                        this.showStorage(true);
                        continue block9;
                    }
                    case VARIABLES: {
                        this.m_ButtonVariables.setSelected(true);
                        this.showVariables(true);
                        continue block9;
                    }
                    case BREAKPOINTS: {
                        this.m_ButtonBreakpoints.setSelected(true);
                        this.showBreakpoints(true);
                        continue block9;
                    }
                }
                throw new IllegalStateException("Unhandled dialog type: " + (Object)((Object)d));
            }
        }
    }

    public boolean addWatch(String expr, ExpressionWatchPanel.ExpressionType type) {
        return this.m_PanelExpressions.addExpression(expr, type);
    }

    public boolean hasWatch(String expr, ExpressionWatchPanel.ExpressionType type) {
        return this.m_PanelExpressions.hasExpression(expr, type);
    }

    @Override
    public void cleanUp() {
        if (this.m_PanelSource != null) {
            this.m_PanelSource = null;
        }
        if (this.m_PanelExpressions != null) {
            this.m_PanelExpressions = null;
        }
        if (this.m_PanelVariables != null) {
            this.m_PanelVariables = null;
        }
        if (this.m_PanelInspectionToken != null) {
            this.m_PanelInspectionToken = null;
        }
        if (this.m_PanelStorage != null) {
            this.m_PanelStorage.cleanUp();
            this.m_PanelStorage = null;
        }
        if (this.m_PanelBreakpoints != null) {
            this.m_PanelBreakpoints.cleanUp();
            this.m_PanelBreakpoints = null;
        }
    }
}

