/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.setup;

import adams.core.CleanUpHandler;
import adams.core.Pausable;
import adams.core.Stoppable;
import adams.event.FlowSetupStateEvent;
import adams.flow.FlowRunner;
import adams.flow.core.AbstractActor;
import adams.flow.setup.FlowSetup;
import javax.swing.SwingWorker;

public class FlowSetupWorker
extends SwingWorker
implements CleanUpHandler,
Stoppable,
Pausable {
    protected FlowSetup m_Setup;
    protected FlowRunner m_FlowRunner;
    protected AbstractActor m_LastActor;

    public FlowSetupWorker(FlowSetup setup) {
        this.m_Setup = setup;
        this.m_FlowRunner = null;
        this.m_LastActor = null;
    }

    public FlowSetup getSetup() {
        return this.m_Setup;
    }

    public AbstractActor getLastActor() {
        return this.m_LastActor;
    }

    protected Object doInBackground() throws Exception {
        this.m_LastActor = null;
        this.m_FlowRunner = new FlowRunner();
        this.m_FlowRunner.setInput(this.m_Setup.getFile());
        this.m_FlowRunner.setHeadless(this.m_Setup.isHeadless());
        this.m_Setup.notifyFlowSetupStateChangeListeners(new FlowSetupStateEvent(this.m_Setup, FlowSetupStateEvent.Type.STARTED));
        String lastError = this.m_FlowRunner.execute();
        this.m_Setup.setLastError(lastError);
        return lastError;
    }

    @Override
    protected void done() {
        this.m_LastActor = this.m_FlowRunner.getLastActor();
        if (this.m_Setup.hasLastError()) {
            this.m_Setup.notifyFlowSetupStateChangeListeners(new FlowSetupStateEvent(this.m_Setup, FlowSetupStateEvent.Type.ERROR));
        } else {
            this.m_Setup.notifyFlowSetupStateChangeListeners(new FlowSetupStateEvent(this.m_Setup, FlowSetupStateEvent.Type.FINISHED));
        }
        this.m_FlowRunner.setInput(null);
        this.m_FlowRunner = null;
        this.m_Setup.finish();
        super.done();
    }

    @Override
    public void pauseExecution() {
        if (this.m_FlowRunner != null) {
            this.m_FlowRunner.pauseExecution();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.m_FlowRunner != null) {
            return this.m_FlowRunner.isPaused();
        }
        return false;
    }

    @Override
    public void resumeExecution() {
        if (this.m_FlowRunner != null) {
            this.m_FlowRunner.resumeExecution();
        }
    }

    @Override
    public void stopExecution() {
        if (this.m_FlowRunner != null) {
            this.m_FlowRunner.stopExecution();
        }
    }

    @Override
    public void cleanUp() {
        this.m_LastActor = null;
        this.m_Setup = null;
        this.m_FlowRunner = null;
    }
}

