/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.control.AbstractConditionalActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.Display;
import java.util.Hashtable;

public class ConditionalSink
extends AbstractConditionalActor
implements InputConsumer {
    private static final long serialVersionUID = -406790756394165537L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Sink that needs to fullfil a condition before being executed.";
    }

    @Override
    protected AbstractActor getDefaultActor() {
        return new Display();
    }

    @Override
    public String actorTipText() {
        return "The base sink to use.";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.UNDEFINED, false);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            ((InputConsumer)((Object)this.m_BaseActor)).input(this.m_InputToken);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && !ActorUtils.isSink(this.m_BaseActor)) {
            result = "Base actor is not a sink!";
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_BaseActor != null) {
            return ((InputConsumer)((Object)this.m_BaseActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        if (!this.m_CheckAtExecutionTime) {
            ((InputConsumer)((Object)this.m_BaseActor)).input(this.m_InputToken);
        }
    }

    @Override
    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    @Override
    public Token currentInput() {
        return this.m_InputToken;
    }

    @Override
    protected String preExecute() {
        String result = super.preExecute();
        if (result == null && this.m_CheckAtExecutionTime) {
            ((InputConsumer)((Object)this.m_BaseActor)).input(this.m_InputToken);
        }
        return result;
    }
}

