/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.flow.sink.AbstractSink;
import java.awt.Desktop;
import java.io.File;

public class OpenFile
extends AbstractSink {
    private static final long serialVersionUID = -2091772083812307932L;

    @Override
    public String globalInfo() {
        return "Opens the incoming file with the appropriate platform-specific application.\nDoes nothing in a headless (non-graphical) environment.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.isHeadless()) {
            if (Desktop.isDesktopSupported()) {
                if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    File file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : (File)this.m_InputToken.getPayload();
                    file = file.getAbsoluteFile();
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to open: " + file, e);
                    }
                } else {
                    result = "The 'Open' file action is not supported by Java on this platform!";
                }
            } else {
                result = "Desktop operations not supported by Java on this platform!";
            }
        }
        return result;
    }
}

