/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.ClassCrossReference;
import adams.core.NamedCounter;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.ActorUtils;
import adams.flow.core.DataPlotUpdaterHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.SimplePlot;
import adams.flow.sink.sequenceplotter.AbstractErrorPaintlet;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;
import adams.flow.sink.sequenceplotter.AbstractSequencePostProcessor;
import adams.flow.sink.sequenceplotter.MarkerPaintlet;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.NoErrorPaintlet;
import adams.flow.sink.sequenceplotter.NoMarkers;
import adams.flow.sink.sequenceplotter.NullClickAction;
import adams.flow.sink.sequenceplotter.PassThrough;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.flow.sink.sequenceplotter.SimplePlotUpdater;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.axis.SimpleTickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.NullPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JComponent;

public class SequencePlotter
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
FileWriter,
ClassCrossReference,
DataPlotUpdaterHandler<AbstractPlotUpdater> {
    private static final long serialVersionUID = 3238389451500168650L;
    protected XYSequencePointComparator.Comparison m_ComparisonType;
    protected XYSequencePaintlet m_Paintlet;
    protected XYSequencePaintlet m_OverlayPaintlet;
    protected MarkerPaintlet m_MarkerPaintlet;
    protected AbstractErrorPaintlet m_ErrorPaintlet;
    protected AbstractColorProvider m_ColorProvider;
    protected AbstractColorProvider m_OverlayColorProvider;
    protected MouseClickAction m_MouseClickAction;
    protected String m_Title;
    protected AxisPanelOptions m_AxisX;
    protected AxisPanelOptions m_AxisY;
    protected AbstractPlotUpdater m_PlotUpdater;
    protected AbstractSequencePostProcessor m_PostProcessor;
    protected NamedCounter m_Counter;
    protected PlaceholderFile m_OutputFile;
    protected Boolean m_UseOutputFile;

    @Override
    public String globalInfo() {
        return "Actor that plots sequences over time.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("comparison", "comparisonType", (Object)XYSequencePointComparator.Comparison.X);
        this.m_OptionManager.add("paintlet", "paintlet", new CirclePaintlet());
        this.m_OptionManager.add("overlay-paintlet", "overlayPaintlet", new NullPaintlet());
        this.m_OptionManager.add("marker-paintlet", "markerPaintlet", new NoMarkers());
        this.m_OptionManager.add("error-paintlet", "errorPaintlet", new NoErrorPaintlet());
        this.m_OptionManager.add("mouse-click-action", "mouseClickAction", new NullClickAction());
        this.m_OptionManager.add("color-provider", "colorProvider", new DefaultColorProvider());
        this.m_OptionManager.add("overlay-color-provider", "overlayColorProvider", new DefaultColorProvider());
        this.m_OptionManager.add("title", "title", "Plot");
        this.m_OptionManager.add("axis-x", "axisX", this.getDefaultAxisX());
        this.m_OptionManager.add("axis-y", "axisY", this.getDefaultAxisY());
        this.m_OptionManager.add("plot-updater", "plotUpdater", new SimplePlotUpdater());
        this.m_OptionManager.add("post-processor", "postProcessor", new PassThrough());
        this.m_OptionManager.add("output", "outputFile", this.getDefaultOutputFile());
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{SimplePlot.class};
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Counter = new NamedCounter();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Counter.clear();
        this.m_UseOutputFile = null;
    }

    @Override
    protected int getDefaultWidth() {
        return 800;
    }

    @Override
    protected int getDefaultHeight() {
        return 350;
    }

    public void setComparisonType(XYSequencePointComparator.Comparison value) {
        this.m_ComparisonType = value;
        this.reset();
    }

    public XYSequencePointComparator.Comparison getComparisonType() {
        return this.m_ComparisonType;
    }

    public String comparisonTypeTipText() {
        return "The type of comparison to use for the data points of the sequence.";
    }

    public void setPaintlet(XYSequencePaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for painting the data.";
    }

    public void setOverlayPaintlet(XYSequencePaintlet value) {
        this.m_OverlayPaintlet = value;
        this.reset();
    }

    public XYSequencePaintlet getOverlayPaintlet() {
        return this.m_OverlayPaintlet;
    }

    public String overlayPaintletTipText() {
        return "The paintlet to use for painting the overlay data (if any).";
    }

    public void setMarkerPaintlet(MarkerPaintlet value) {
        this.m_MarkerPaintlet = value;
        this.reset();
    }

    public MarkerPaintlet getMarkerPaintlet() {
        return this.m_MarkerPaintlet;
    }

    public String markerPaintletTipText() {
        return "The marker paintlet to use for painting marker overlays.";
    }

    public void setErrorPaintlet(AbstractErrorPaintlet value) {
        this.m_ErrorPaintlet = value;
        this.reset();
    }

    public AbstractErrorPaintlet getErrorPaintlet() {
        return this.m_ErrorPaintlet;
    }

    public String errorPaintletTipText() {
        return "The paintlet to use for painting error overlays.";
    }

    public void setMouseClickAction(MouseClickAction value) {
        this.m_MouseClickAction = value;
        this.reset();
    }

    public MouseClickAction getMouseClickAction() {
        return this.m_MouseClickAction;
    }

    public String mouseClickActionTipText() {
        return "The action to use for mouse clicks on the canvas.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for generating the colors for the various plots.";
    }

    public void setOverlayColorProvider(AbstractColorProvider value) {
        this.m_OverlayColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getOverlayColorProvider() {
        return this.m_OverlayColorProvider;
    }

    public String overlayColorProviderTipText() {
        return "The color provider in use for generating the colors for the overlay plots.";
    }

    protected AxisPanelOptions getDefaultAxisX() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("x");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setWidth(40);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        SimpleTickGenerator tick = new SimpleTickGenerator();
        tick.setNumTicks(20);
        result.setTickGenerator(tick);
        return result;
    }

    protected AxisPanelOptions getDefaultAxisY() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("y");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setWidth(60);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        SimpleTickGenerator tick = new SimpleTickGenerator();
        tick.setNumTicks(10);
        result.setTickGenerator(tick);
        return result;
    }

    public void setAxisX(AxisPanelOptions value) {
        this.m_AxisX = value;
        this.reset();
    }

    public AxisPanelOptions getAxisX() {
        return this.m_AxisX;
    }

    public String axisXTipText() {
        return "The setup for the X axis.";
    }

    public void setAxisY(AxisPanelOptions value) {
        this.m_AxisY = value;
        this.reset();
    }

    public AxisPanelOptions getAxisY() {
        return this.m_AxisY;
    }

    public String axisYTipText() {
        return "The setup for the Y axis.";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title for the border around the plot.";
    }

    @Override
    public void setPlotUpdater(AbstractPlotUpdater value) {
        this.m_PlotUpdater = value;
        this.reset();
    }

    @Override
    public AbstractPlotUpdater getPlotUpdater() {
        return this.m_PlotUpdater;
    }

    @Override
    public String plotUpdaterTipText() {
        return "The updating strategy for the plot.";
    }

    public void setPostProcessor(AbstractSequencePostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractSequencePostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to use on the sequences after a token has been added.";
    }

    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile(".");
    }

    @Override
    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    @Override
    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    @Override
    public String outputFileTipText() {
        return "The file to write the plot containers to (in CSV format); does not store the meta-data, as it can change from container to container; ignored if pointing to a directory.";
    }

    @Override
    public void clearPanel() {
        if (this.m_Panel != null) {
            ((XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager()).clear();
            ((SequencePlotterPanel)this.m_Panel).getMarkerContainerManager().clear();
        }
    }

    @Override
    protected BasePanel newPanel() {
        SequencePlotterPanel result = new SequencePlotterPanel(this.getTitle());
        result.setPaintlet(this.getPaintlet());
        result.setOverlayPaintlet((XYSequencePaintlet)this.getOverlayPaintlet().shallowCopy());
        result.setMarkerPaintlet((MarkerPaintlet)this.getMarkerPaintlet().shallowCopy());
        result.setErrorPaintlet((AbstractErrorPaintlet)this.getErrorPaintlet().shallowCopy());
        result.setMouseClickAction(this.m_MouseClickAction);
        this.m_AxisX.configure(result.getPlot(), Axis.BOTTOM);
        this.m_AxisY.configure(result.getPlot(), Axis.LEFT);
        result.setColorProvider(this.getColorProvider().shallowCopy());
        result.setOverlayColorProvider(this.getOverlayColorProvider().shallowCopy());
        ActorUtils.updateFlowAwarePaintlet(result.getPaintlet(), this);
        ActorUtils.updateFlowAwarePaintlet(result.getOverlayPaintlet(), this);
        ActorUtils.updateFlowAwarePaintlet(result.getMarkerPaintlet(), this);
        ActorUtils.updateFlowAwarePaintlet(result.getErrorPaintlet(), this);
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    protected boolean writePlotContainer(String name, SequencePlotterContainer.ContentType type, Comparable x, Comparable y, double dX, double dY, Double[] errorX, Double[] errorY) {
        StringBuilder line;
        boolean result = true;
        if (!this.m_OutputFile.exists()) {
            line = new StringBuilder();
            line.append("# " + this.toCommandLine());
            line.append("\n");
            line.append("Plot");
            line.append(",");
            line.append("Type");
            line.append(",");
            line.append("X");
            line.append(",");
            line.append("Y");
            line.append(",");
            line.append("X-numeric");
            line.append(",");
            line.append("Y-numeric");
            line.append(",");
            line.append("X-error-low");
            line.append(",");
            line.append("X-error-high");
            line.append(",");
            line.append("Y-error-low");
            line.append(",");
            line.append("Y-error-high");
            result = FileUtils.writeToFile(this.m_OutputFile.getAbsolutePath(), (Object)line.toString(), false);
        }
        if (result) {
            int decimals = 12;
            line = new StringBuilder();
            line.append(Utils.doubleQuote(name));
            line.append(",");
            line.append(Utils.doubleQuote(type.toString()));
            line.append(",");
            line.append(x);
            line.append(",");
            line.append(y);
            line.append(",");
            line.append(Utils.doubleToString(dX, decimals));
            line.append(",");
            line.append(Utils.doubleToString(dY, decimals));
            line.append(",");
            if (errorX != null && (errorX.length == 1 || errorX.length == 2)) {
                if (errorX.length == 1) {
                    line.append(Utils.doubleToString(errorX[0], decimals));
                    line.append(",");
                    line.append(",");
                } else {
                    line.append(Utils.doubleToString(errorX[0], decimals));
                    line.append(",");
                    line.append(Utils.doubleToString(errorX[1], decimals));
                    line.append(",");
                }
            } else {
                line.append(",");
                line.append(",");
            }
            if (errorY != null && (errorY.length == 1 || errorY.length == 2)) {
                if (errorY.length == 1) {
                    line.append(Utils.doubleToString(errorY[0], decimals));
                    line.append(",");
                } else {
                    line.append(Utils.doubleToString(errorY[0], decimals));
                    line.append(",");
                    line.append(Utils.doubleToString(errorY[1], decimals));
                }
            } else {
                line.append(",");
            }
            result = FileUtils.writeToFile(this.m_OutputFile.getAbsolutePath(), (Object)line.toString(), true);
        }
        return result;
    }

    @Override
    protected void display(Token token) {
        XYSequence seq;
        XYSequenceContainerManager manager;
        SequencePlotterContainer plotCont = (SequencePlotterContainer)token.getPayload();
        String plotName = (String)plotCont.getValue("PlotName");
        Comparable x = (Comparable)plotCont.getValue("X");
        Comparable y = (Comparable)plotCont.getValue("Y");
        Double[] errorX = (Double[])plotCont.getValue("Error X");
        Double[] errorY = (Double[])plotCont.getValue("Error Y");
        SequencePlotterContainer.ContentType type = (SequencePlotterContainer.ContentType)((Object)plotCont.getValue("Content type"));
        HashMap<String, Object> meta = plotCont.getMetaData();
        switch (type) {
            case PLOT: {
                manager = (XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager();
                break;
            }
            case MARKER: {
                manager = ((SequencePlotterPanel)this.m_Panel).getMarkerContainerManager();
                break;
            }
            case OVERLAY: {
                manager = ((SequencePlotterPanel)this.m_Panel).getOverlayContainerManager();
                break;
            }
            case UPDATE: {
                this.m_PlotUpdater.update((SequencePlotterPanel)this.getPanel());
                return;
            }
            default: {
                throw new IllegalStateException("Unhandled plot container content type: " + (Object)((Object)type));
            }
        }
        manager.startUpdate();
        if (manager.indexOf(plotName) == -1) {
            seq = new SequencePlotSequence();
            seq.setComparison(this.m_ComparisonType);
            seq.setID(plotName);
            XYSequenceContainer cont = manager.newContainer(seq);
            manager.add(cont);
        } else {
            XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(plotName));
            seq = cont.getData();
        }
        if (x == null) {
            x = new Double(this.m_Counter.next(plotName));
        }
        double dX = x instanceof Number ? ((Number)((Object)x)).doubleValue() : seq.putMappingX(x.toString());
        double dY = y instanceof Number ? ((Number)((Object)y)).doubleValue() : seq.putMappingY(y.toString());
        SequencePlotPoint point = new SequencePlotPoint("" + seq.size(), dX, dY, errorX, errorY);
        if (meta != null) {
            point.setMetaData(meta);
        }
        seq.add(point);
        if (this.m_UseOutputFile == null) {
            this.m_UseOutputFile = !this.m_OutputFile.isDirectory();
        }
        if (this.m_UseOutputFile.booleanValue()) {
            this.writePlotContainer(plotName, type, x, y, dX, dY, errorX, errorY);
        }
        if (type != SequencePlotterContainer.ContentType.MARKER) {
            this.m_PostProcessor.postProcess(manager, plotName);
        }
        this.m_PlotUpdater.update((SequencePlotterPanel)this.getPanel(), plotCont);
    }

    @Override
    public void updatePlot() {
        this.m_PlotUpdater.update((SequencePlotterPanel)this.getPanel());
    }

    @Override
    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(this.getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected SequencePlotterPanel m_Panel;

            @Override
            protected void initGUI() {
                super.initGUI();
                this.m_Panel = new SequencePlotterPanel(SequencePlotter.this.getTitle());
                this.m_Panel.setPaintlet(SequencePlotter.this.getPaintlet());
                this.m_Panel.setOverlayPaintlet(SequencePlotter.this.m_OverlayPaintlet);
                this.m_Panel.setMarkerPaintlet(SequencePlotter.this.getMarkerPaintlet());
                this.m_Panel.setErrorPaintlet(SequencePlotter.this.m_ErrorPaintlet);
                this.m_Panel.setMouseClickAction(SequencePlotter.this.m_MouseClickAction);
                SequencePlotter.this.m_AxisX.configure(this.m_Panel.getPlot(), Axis.BOTTOM);
                SequencePlotter.this.m_AxisY.configure(this.m_Panel.getPlot(), Axis.LEFT);
                this.m_Panel.setColorProvider(SequencePlotter.this.m_ColorProvider);
                this.m_Panel.setOverlayColorProvider(SequencePlotter.this.m_OverlayColorProvider);
                this.add((Component)this.m_Panel, "Center");
                ActorUtils.updateFlowAwarePaintlet(this.m_Panel.getPaintlet(), SequencePlotter.this);
                ActorUtils.updateFlowAwarePaintlet(this.m_Panel.getOverlayPaintlet(), SequencePlotter.this);
                ActorUtils.updateFlowAwarePaintlet(this.m_Panel.getMarkerPaintlet(), SequencePlotter.this);
                ActorUtils.updateFlowAwarePaintlet(this.m_Panel.getErrorPaintlet(), SequencePlotter.this);
            }

            @Override
            public void display(Token token) {
                XYSequence seq;
                XYSequenceContainerManager manager;
                SequencePlotterContainer plotCont = (SequencePlotterContainer)token.getPayload();
                String plotName = (String)plotCont.getValue("PlotName");
                Double x = (Double)plotCont.getValue("X");
                Double y = (Double)plotCont.getValue("Y");
                SequencePlotterContainer.ContentType type = (SequencePlotterContainer.ContentType)((Object)plotCont.getValue("Content type"));
                switch (type) {
                    case PLOT: {
                        manager = (XYSequenceContainerManager)this.m_Panel.getContainerManager();
                        break;
                    }
                    case MARKER: {
                        manager = this.m_Panel.getMarkerContainerManager();
                        break;
                    }
                    case OVERLAY: {
                        manager = this.m_Panel.getOverlayContainerManager();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled plot container content type: " + (Object)((Object)type));
                    }
                }
                manager.startUpdate();
                if (manager.indexOf(plotName) == -1) {
                    seq = new XYSequence();
                    seq.setComparison(SequencePlotter.this.m_ComparisonType);
                    seq.setID(plotName);
                    XYSequenceContainer cont = manager.newContainer(seq);
                    manager.add(cont);
                } else {
                    XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(plotName));
                    seq = cont.getData();
                }
                if (x == null) {
                    x = new Double(SequencePlotter.this.m_Counter.next(plotName));
                }
                XYSequencePoint point = new XYSequencePoint("" + seq.size(), x, y);
                seq.add(point);
                if (type != SequencePlotterContainer.ContentType.MARKER) {
                    SequencePlotter.this.m_PostProcessor.postProcess(manager, plotName);
                }
                SequencePlotter.this.m_PlotUpdater.update(this.m_Panel, plotCont);
            }

            @Override
            public void clearPanel() {
                ((XYSequenceContainerManager)this.m_Panel.getContainerManager()).clear();
            }

            @Override
            public void cleanUp() {
                ((XYSequenceContainerManager)this.m_Panel.getContainerManager()).clear();
            }

            @Override
            public JComponent supplyComponent() {
                return this.m_Panel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    @Override
    public void wrapUp() {
        if (this.m_Panel != null) {
            this.m_PlotUpdater.update((SequencePlotterPanel)this.m_Panel);
        }
        super.wrapUp();
    }
}

