/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class DumpStorage
extends AbstractSimpleSource {
    private static final long serialVersionUID = -6626384935427295809L;
    protected String m_Cache;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Outputs a spreadsheet with the storage names and the string representation of their associated values.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, this.m_Invert ? "! " : "");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "cache", this.m_Cache.isEmpty() ? "-none-" : this.m_Cache, ", cache: ");
        return result;
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to retrieve the storage item names; uses the regular storage if left empty.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the storage names.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    @Override
    protected String doExecute() {
        ArrayList<StorageName> names = new ArrayList<StorageName>();
        Storage var = this.getStorageHandler().getStorage();
        Set<StorageName> set = this.m_Cache.isEmpty() ? this.getStorageHandler().getStorage().keySet() : this.getStorageHandler().getStorage().keySet(this.m_Cache);
        if (this.m_RegExp.isMatchAll()) {
            if (!this.m_Invert) {
                names.addAll(set);
            }
        } else {
            for (StorageName name : set) {
                if (this.m_Invert && !this.m_RegExp.isMatch(name.getValue())) {
                    names.add(name);
                    continue;
                }
                if (this.m_Invert || !this.m_RegExp.isMatch(name.getValue())) continue;
                names.add(name);
            }
        }
        Collections.sort(names);
        SpreadSheet sheet = new SpreadSheet();
        sheet.setName("Storage");
        Row row = sheet.getHeaderRow();
        row.addCell("K").setContent("Name");
        row.addCell("V").setContent("Value");
        for (StorageName name : names) {
            row = sheet.addRow();
            row.addCell("K").setContentAsString(name.getValue());
            if (this.m_Cache.isEmpty()) {
                row.addCell("V").setContentAsString("" + var.get(name));
                continue;
            }
            row.addCell("V").setContentAsString("" + var.get(this.m_Cache, name));
        }
        this.m_OutputToken = new Token(sheet);
        return null;
    }
}

