/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Properties;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.flow.source.ValueDefinition;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnterManyValues
extends AbstractInteractiveSource
implements AutomatableInteractiveActor {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_Message;
    protected ValueDefinition[] m_Values;
    protected OutputType m_OutputType;
    protected boolean m_NonInteractive;
    protected List m_Queue;

    @Override
    public String globalInfo() {
        return "Pops up a dialog, prompting the user to enter one or more values.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Please enter values");
        this.m_OptionManager.add("value", "values", new ValueDefinition[0]);
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.SPREADSHEET);
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Queue = new ArrayList();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "message", this.m_Message);
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "stopFlowIfCanceled", this.m_StopFlowIfCanceled, "stops flow if canceled"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "nonInteractive", this.m_NonInteractive, "non-interactive"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputType", (Object)this.m_OutputType));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with.";
    }

    public void setValues(ValueDefinition[] value) {
        this.m_Values = value;
        this.reset();
    }

    public ValueDefinition[] getValues() {
        return this.m_Values;
    }

    public String valuesTipText() {
        return "The value definitions that define the dialog prompting the user to enter the values.";
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "How to output the entered data.";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, the initial value is forwarded without user interaction.";
    }

    @Override
    public Class[] generates() {
        switch (this.m_OutputType) {
            case SPREADSHEET: {
                return new Class[]{SpreadSheet.class};
            }
            case KEY_VALUE_PAIRS: {
                return new Class[]{String[].class};
            }
            case KEY_VALUE_PAIRS_ARRAY: {
                return new Class[]{String[][].class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Values.length == 0) {
            result = "No values defined!";
        }
        return result;
    }

    protected Properties getDefaultProperties() {
        Properties result = new Properties();
        for (ValueDefinition val : this.m_Values) {
            result.setProperty(val.getName(), this.getVariables().expand(val.getDefaultValue()));
        }
        return result;
    }

    protected SpreadSheet propertiesToSpreadSheet(Properties props) {
        SpreadSheet result = new SpreadSheet();
        Row row = result.getHeaderRow();
        for (ValueDefinition val : this.m_Values) {
            row.addCell(val.getName()).setContent(val.getName());
        }
        row = result.addRow();
        block9: for (ValueDefinition val : this.m_Values) {
            switch (val.getType()) {
                case INTEGER: {
                    row.addCell(val.getName()).setContent(props.getInteger(val.getName()));
                    continue block9;
                }
                case DOUBLE: {
                    row.addCell(val.getName()).setContent(props.getDouble(val.getName()));
                    continue block9;
                }
                case BOOLEAN: {
                    row.addCell(val.getName()).setContent(props.getBoolean(val.getName()));
                    continue block9;
                }
                case TIME: {
                    row.addCell(val.getName()).setContent(props.getTime(val.getName()));
                    continue block9;
                }
                case DATE: {
                    row.addCell(val.getName()).setContent(props.getDate(val.getName()));
                    continue block9;
                }
                case DATETIME: {
                    row.addCell(val.getName()).setContent(props.getDateTime(val.getName()));
                    continue block9;
                }
                default: {
                    row.addCell(val.getName()).setContentAsString(props.getProperty(val.getName()));
                }
            }
        }
        return result;
    }

    protected Token[] propertiesToOutputType(Properties props) {
        Token[] result;
        switch (this.m_OutputType) {
            case SPREADSHEET: {
                result = new Token[]{new Token(this.propertiesToSpreadSheet(props))};
                break;
            }
            case KEY_VALUE_PAIRS: {
                SpreadSheet sheet = this.propertiesToSpreadSheet(props);
                result = new Token[sheet.getColumnCount()];
                for (int i = 0; i < sheet.getColumnCount(); ++i) {
                    String[] pair = new String[]{sheet.getHeaderRow().getCell(i).getContent(), sheet.getRow(0).getCell(i).getContent()};
                    result[i] = new Token(pair);
                }
                break;
            }
            case KEY_VALUE_PAIRS_ARRAY: {
                SpreadSheet sheet = this.propertiesToSpreadSheet(props);
                result = new Token[1];
                String[][] pairArray = new String[sheet.getColumnCount()][2];
                for (int i = 0; i < sheet.getColumnCount(); ++i) {
                    String[] pair = new String[]{sheet.getHeaderRow().getCell(i).getContent(), sheet.getRow(0).getCell(i).getContent()};
                    pairArray[i] = pair;
                }
                result[0] = new Token(pairArray);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doInteract() {
        this.m_Queue.clear();
        if (this.m_NonInteractive) {
            this.m_Queue.addAll(Arrays.asList(this.propertiesToOutputType(this.getDefaultProperties())));
            return true;
        }
        PropertiesParameterPanel panel = new PropertiesParameterPanel();
        panel.setButtonPanelVisible(true);
        ArrayList<String> order = new ArrayList<String>();
        for (ValueDefinition val : this.m_Values) {
            order.add(val.getName());
            panel.addPropertyType(val.getName(), val.getType());
            if (!val.getDisplay().trim().isEmpty()) {
                panel.setLabel(val.getName(), val.getDisplay());
            }
            if (val.getHelp().trim().isEmpty()) continue;
            panel.setHelp(val.getName(), val.getHelp());
        }
        panel.setPropertyOrder(order);
        panel.setProperties(this.getDefaultProperties());
        JPanel panelMsg = new JPanel(new FlowLayout(0));
        panelMsg.add(new JLabel(this.m_Message));
        ApprovalDialog dialog = new ApprovalDialog(null, Dialog.ModalityType.MODELESS);
        dialog.setTitle(this.getName());
        dialog.getContentPane().add((Component)panelMsg, "North");
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        Boolean sync = new Boolean(true);
        while (!dialog.isVisible()) {
            try {
                Boolean exception = sync;
                synchronized (exception) {
                    sync.wait(10L);
                }
            }
            catch (Exception exception) {
            }
        }
        while (dialog.isVisible() && !this.isStopped()) {
            try {
                Boolean bl = sync;
                synchronized (bl) {
                    sync.wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
        if (this.isStopped()) {
            dialog.setVisible(false);
        }
        if (dialog.getOption() == 0) {
            Properties props = panel.getProperties();
            this.m_Queue.addAll(Arrays.asList(this.propertiesToOutputType(props)));
            return true;
        }
        return false;
    }

    @Override
    protected String doExecute() {
        if (this.isHeadless()) {
            this.m_Queue.addAll(Arrays.asList(this.propertiesToOutputType(this.getDefaultProperties())));
            return null;
        }
        return super.doExecute();
    }

    @Override
    public Token output() {
        Token result = null;
        if (this.m_Queue != null && !this.m_Queue.isEmpty()) {
            result = (Token)this.m_Queue.remove(0);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.m_Queue = null;
    }

    public static enum OutputType {
        SPREADSHEET,
        KEY_VALUE_PAIRS,
        KEY_VALUE_PAIRS_ARRAY;

    }
}

