/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.ArrayProvider;
import adams.flow.core.Token;
import adams.flow.source.AbstractForLoop;
import java.util.ArrayList;

public class ForLoop
extends AbstractForLoop
implements ArrayProvider {
    private static final long serialVersionUID = 6216146938771296415L;
    protected boolean m_OutputArray;
    protected Integer[] m_Array;

    @Override
    public String globalInfo() {
        return "Emulates the following for-loop for integer IDs:\n- positive step size:\n  for (int i = lower; i <= upper; i += step)\n- negative step size:\n  for (int i = upper; i >= lower; i += step)\n\nThe integers can be output as a single array as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-array", "outputArray", false);
    }

    @Override
    public void setOutputArray(boolean value) {
        this.m_OutputArray = value;
        this.reset();
    }

    @Override
    public boolean getOutputArray() {
        return this.m_OutputArray;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the integers one-by-one or as array.";
    }

    @Override
    public Class[] generates() {
        if (this.m_OutputArray) {
            return new Class[]{Integer[].class};
        }
        return new Class[]{Integer.class};
    }

    @Override
    protected String doExecute() {
        ArrayList<Integer> array;
        if (this.m_OutputArray) {
            array = new ArrayList<Integer>();
            for (int i = this.m_LoopLower; i <= this.m_LoopUpper; i += this.m_LoopStep) {
                array.add(i);
            }
        } else {
            return super.doExecute();
        }
        this.m_Array = array.toArray(new Integer[array.size()]);
        return null;
    }

    @Override
    public boolean hasPendingOutput() {
        if (this.m_OutputArray) {
            return this.m_Executed && this.m_Array != null;
        }
        return super.hasPendingOutput();
    }

    @Override
    public Token output() {
        Token result;
        if (this.m_OutputArray) {
            result = new Token(this.m_Array);
            this.m_Array = null;
        } else {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("i=" + this.m_Current);
            }
            result = new Token(new Integer(this.m_Current));
            this.m_Current += this.m_LoopStep;
        }
        return result;
    }
}

