/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractArrayProvider;

public class IntegerRange
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8634150731979965438L;
    protected Range m_Range;
    protected int m_Max;
    protected boolean m_ZeroBased;

    @Override
    public String globalInfo() {
        return "Outputs the integers defined by the range expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", new Range("first-last"));
        this.m_OptionManager.add("max", "max", 100, 1, null);
        this.m_OptionManager.add("zero-based", "zeroBased", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "range", this.m_Range, "range: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "max", this.m_Max, ", max: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "zeroBased", this.m_ZeroBased ? "0-based" : "1-based", ", ");
        return result;
    }

    public void setRange(Range value) {
        this.m_Range = value;
        this.reset();
    }

    public Range getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range expression to use for generating the integers.";
    }

    public void setMax(int value) {
        this.m_Max = value;
        this.reset();
    }

    public int getMax() {
        return this.m_Max;
    }

    public String maxTipText() {
        return "The maximum number for the range.";
    }

    public void setZeroBased(boolean value) {
        this.m_ZeroBased = value;
        this.reset();
    }

    public boolean getZeroBased() {
        return this.m_ZeroBased;
    }

    public String zeroBasedTipText() {
        return "If enabled, 0-based integers are output instead of 1-based ones ('first' = 0 instead of 1).";
    }

    @Override
    protected Class getItemClass() {
        return Integer.class;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the integers one-by-one or as an array.";
    }

    @Override
    protected String doExecute() {
        this.m_Queue.clear();
        this.m_Range.setMax(this.m_Max);
        for (int i : this.m_Range.getIntIndices()) {
            if (this.m_ZeroBased) {
                this.m_Queue.add(i);
                continue;
            }
            this.m_Queue.add(i + 1);
        }
        return null;
    }
}

