/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpression;
import adams.parser.MathematicalExpressionText;
import java.util.HashMap;

public class MathExpression
extends AbstractSimpleSource
implements GrammarSupplier {
    private static final long serialVersionUID = -8477454145267616359L;
    protected MathematicalExpressionText m_Expression;

    @Override
    public String globalInfo() {
        return "Evaluates a mathematical expression.\nVariables are supported as well, e.g.: pow(X,@{exp}) with '@{exp}' being a variable available at execution time.\n\nThe following grammar is used for the expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", new MathematicalExpressionText("1.0"));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "expression", this.m_Expression);
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
        this.reset();
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to evaluate.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{Double.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && (this.m_Expression == null || this.m_Expression.getValue().length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String exp = this.m_Expression.getValue();
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Expression: " + exp);
            }
            exp = this.getVariables().expand(exp);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("--> expanded: " + exp);
            }
            Double res = null;
            res = MathematicalExpression.evaluate(exp, new HashMap());
            if (res != null) {
                this.m_OutputToken = new Token(new Double(res));
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("--> res: " + res);
                }
            } else {
                result = "Failed to generate output?";
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Error evaluating: " + exp, e);
        }
        return result;
    }
}

