/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.newlist;

import adams.core.base.BaseString;
import adams.flow.source.newlist.AbstractListGenerator;
import java.util.ArrayList;
import java.util.List;

public class FixedList
extends AbstractListGenerator {
    private static final long serialVersionUID = -4623795710416726074L;
    protected BaseString[] m_Elements;

    @Override
    public String globalInfo() {
        return "Simply outputs the supplied list elements.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("element", "elements", new BaseString[0]);
    }

    public void setElements(BaseString[] value) {
        this.m_Elements = value;
        this.reset();
    }

    public BaseString[] getElements() {
        return this.m_Elements;
    }

    public String elementsTipText() {
        return "The list elements to output.";
    }

    @Override
    protected void check() throws Exception {
        super.check();
        if (this.m_Elements.length == 0) {
            throw new IllegalStateException("No list elements supplied!");
        }
    }

    @Override
    protected List<String> doGenerate() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (BaseString element : this.m_Elements) {
            result.add(element.getValue());
        }
        return result;
    }
}

