/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.newlist;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.source.newlist.AbstractListGenerator;
import adams.flow.source.newlist.FixedList;
import java.util.ArrayList;
import java.util.List;

public class Wrapper
extends AbstractListGenerator {
    private static final long serialVersionUID = -4623795710416726074L;
    protected AbstractListGenerator m_Generator;
    protected String m_Prefix;
    protected String m_Suffix;

    @Override
    public String globalInfo() {
        return "Wraps the list items produced by the specified generator with user-supplied prefix and suffix.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new FixedList());
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("suffix", "suffix", "");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "generator", this.m_Generator, "generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "prefix", this.m_Prefix.isEmpty() ? "-none-" : this.m_Prefix, ", prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "suffix", this.m_Suffix.isEmpty() ? "-none-" : this.m_Suffix, ", suffix: ");
        return result;
    }

    public void setGenerator(AbstractListGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractListGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The list generator to use.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix to use.";
    }

    @Override
    protected List<String> doGenerate() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.m_Generator.generate());
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, this.m_Prefix + (String)result.get(i) + this.m_Suffix);
        }
        return result;
    }
}

