/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.option.OptionHandler;
import adams.db.datatype.AbstractDataTypeSetup;
import adams.db.datatype.DummySetup;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;

public abstract class AbstractDatabaseConnection
extends AbstractStandalone
implements OptionalPasswordPrompt {
    private static final long serialVersionUID = -1726172998200420556L;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected AbstractDataTypeSetup m_DataTypeSetup;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", "jdbc:mysql://somehost:3306/somedatabase", false);
        this.m_OptionManager.add("user", "user", "", false);
        this.m_OptionManager.add("password", "password", new BasePassword(), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", false);
        this.m_OptionManager.add("data-type-setup", "dataTypeSetup", new DummySetup());
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", "");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "URL", this.m_URL);
        if (QuickInfoHelper.hasVariable(this, "promptForPassword") || this.m_PromptForPassword) {
            result = result + ", prompt for password";
            result = result + QuickInfoHelper.toString((OptionHandler)this, "stopFlowIfCanceled", this.m_StopFlowIfCanceled, "stop flow", ", ");
        }
        return result;
    }

    public void setURL(String value) {
        this.m_URL = value;
        this.reset();
    }

    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The JDBC URL of the database to connect to, can contain variables or file placeholders.";
    }

    public String getResolvedURL() {
        String result = this.m_URL;
        result = this.getVariables().expand(result);
        result = Placeholders.expandStr(result);
        return result;
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The database user to connect with.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the database user.";
    }

    @Override
    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    @Override
    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    @Override
    public String promptForPasswordTipText() {
        return "If enabled and authentication is required, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setDataTypeSetup(AbstractDataTypeSetup value) {
        this.m_DataTypeSetup = value;
        this.reset();
    }

    public AbstractDataTypeSetup getDataTypeSetup() {
        return this.m_DataTypeSetup;
    }

    public String dataTypeSetupTipText() {
        return "The data type setup to apply to the connection.";
    }

    @Override
    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    @Override
    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    @Override
    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    @Override
    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    @Override
    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    @Override
    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    @Override
    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        dlg.setVisible(true);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String msg;
        String result = null;
        this.m_ActualPassword = this.m_Password;
        adams.db.AbstractDatabaseConnection conn = null;
        if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0 && !this.isHeadless() && !this.doInteract() && this.m_StopFlowIfCanceled) {
            if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                this.stopExecution("Flow canceled: " + this.getFullName());
            } else {
                this.stopExecution(this.m_CustomStopMessage);
            }
            result = this.getStopMessage();
        }
        if (result == null) {
            conn = this.getConnection();
            msg = null;
            if (!conn.isConnected() && !conn.getConnectOnStartUp()) {
                try {
                    conn.connect();
                }
                catch (Exception e) {
                    msg = this.handleException("Failed to connect to database (" + this.getURL() + "):", e);
                }
            }
            if (!conn.isConnected()) {
                result = "Failed to connect to database (" + this.getURL() + ")";
                result = msg == null ? result + "!" : result + ": " + msg;
            }
        }
        if (result == null && (msg = this.m_DataTypeSetup.setupDataTypes(conn.getConnection(false))) != null) {
            result = "Failed to setup data types: " + msg;
        }
        return result;
    }

    public abstract adams.db.AbstractDatabaseConnection getConnection();
}

