/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.control.AbstractDirector;
import adams.flow.control.MutableControlActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.CallableActorHandler;
import java.util.HashSet;

public class CallableActors
extends MutableControlActor
implements CallableActorHandler {
    private static final long serialVersionUID = -5282103315016094476L;

    @Override
    public String globalInfo() {
        return "Container for actors that need to be accessed via their name.";
    }

    @Override
    protected AbstractDirector newDirector() {
        return new CallableActorsDirector();
    }

    @Override
    public String actorsTipText() {
        return "All the actors that are to be accessed via their name.";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.UNDEFINED, false);
    }

    protected String checkNames() {
        String result = null;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (names.contains(this.get(i).getName())) {
                result = "Actor '" + this.get(i).getFullName() + "' has duplicate name '" + this.get(i).getName() + "'!";
                break;
            }
            if (this.getScopeHandler() != null) {
                result = this.getScopeHandler().addCallableName(this.get(i).getName());
            }
            if (result != null) break;
            names.add(this.get(i).getName());
        }
        return result;
    }

    protected String checkCallableActorHandlers() {
        ActorHandler parent;
        String result = null;
        if (this.getParent() instanceof ActorHandler && (parent = (ActorHandler)((Object)this.getParent())) != null) {
            int index = this.index();
            for (int i = index + 1; i < parent.size(); ++i) {
                if (!(parent.get(i) instanceof CallableActorHandler)) continue;
                result = this.getClass().getSimpleName() + " cannot be followed by another " + CallableActorHandler.class.getSimpleName() + " actor: " + "#" + (i + 1) + " " + parent.get(i).getName() + "/" + parent.get(i).getClass().getName();
                break;
            }
        }
        return result;
    }

    @Override
    public String check() {
        String result = this.checkNames();
        if (result == null) {
            result = this.checkCallableActorHandlers();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        return null;
    }

    @Override
    public void wrapUp() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).wrapUp();
        }
        super.wrapUp();
    }

    public static class CallableActorsDirector
    extends AbstractDirector {
        private static final long serialVersionUID = -7581710637774405432L;

        @Override
        public String execute() {
            return null;
        }
    }
}

