/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;

public abstract class AbstractActorTemplate
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractActorTemplate> {
    private static final long serialVersionUID = 4962299214177742036L;
    protected String m_Name;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", "");
    }

    public void setName(String value) {
        if (value != null) {
            this.m_Name = value;
            this.reset();
        } else {
            this.getLogger().severe("Name cannot be null!");
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The new name for the actor; leave empty to use current.";
    }

    protected void preGenerate() {
    }

    protected abstract AbstractActor doGenerate();

    protected AbstractActor postGenerate(AbstractActor actor) {
        if (this.m_Name.length() > 0) {
            actor.setName(this.m_Name);
        }
        return actor;
    }

    public AbstractActor generate() {
        this.getLogger().fine("preGenerate");
        this.preGenerate();
        this.getLogger().fine("doGenerate");
        AbstractActor result = this.doGenerate();
        this.getLogger().fine("  --> generated result? " + (result != null));
        if (result != null) {
            this.getLogger().fine("postGenerate");
            result = this.postGenerate(result);
            this.getLogger().fine("  --> generated result? " + (result != null));
        }
        return result;
    }

    @Override
    public AbstractActorTemplate shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractActorTemplate shallowCopy(boolean expand) {
        return (AbstractActorTemplate)OptionUtils.shallowCopy(this, expand);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine((AbstractActorTemplate)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public static String[] getBaselineCorrections() {
        return ClassLister.getSingleton().getClassnames(AbstractActorTemplate.class);
    }

    public static AbstractActorTemplate forName(String classname, String[] options) {
        AbstractActorTemplate result;
        try {
            result = (AbstractActorTemplate)OptionUtils.forName(AbstractActorTemplate.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractActorTemplate forCommandLine(String cmdline) {
        return (AbstractActorTemplate)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

