/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.CompressionSupporter;
import adams.data.DataUtils;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.MetaFileWriter;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class AbstractDataContainerFileWriter<T extends DataContainer>
extends AbstractTransformer {
    private static final long serialVersionUID = -2589436559371405252L;
    protected AbstractDataContainerWriter<T> m_Writer;
    protected PlaceholderDirectory m_OutputDir;
    protected FileNameGeneration m_FileNameGeneration;
    protected String m_SuppliedFileName;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", this.getDefaultWriter());
        this.m_OptionManager.add("dir", "outputDir", new PlaceholderDirectory("."));
        this.m_OptionManager.add("file-name-generation", "fileNameGeneration", (Object)FileNameGeneration.AUTOMATIC);
        this.m_OptionManager.add("supplied-file-name", "suppliedFileName", this.getDefaultSuppliedFileName());
    }

    protected abstract AbstractDataContainerWriter<T> getDefaultWriter();

    public void setWriter(AbstractDataContainerWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractDataContainerWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for saving the data.";
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory for the data.";
    }

    public void setFileNameGeneration(FileNameGeneration value) {
        this.m_FileNameGeneration = value;
        this.reset();
    }

    public FileNameGeneration getFileNameGeneration() {
        return this.m_FileNameGeneration;
    }

    public String fileNameGenerationTipText() {
        return "Defines how to generate the file name.";
    }

    protected String getDefaultSuppliedFileName() {
        return "out." + this.getDefaultExtension();
    }

    public void setSuppliedFileName(String value) {
        this.m_SuppliedFileName = value;
        this.reset();
    }

    public String getSuppliedFileName() {
        return this.m_SuppliedFileName;
    }

    public String suppliedFileNameTipText() {
        return "The file name (without path) to use when using " + (Object)((Object)FileNameGeneration.SUPPLIED) + " (including extension).";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "writer", this.m_Writer);
    }

    protected abstract Class getDataContainerClass();

    @Override
    public Class[] accepts() {
        Class<?> cls = Array.newInstance(this.getDataContainerClass(), 0).getClass();
        return new Class[]{cls.getComponentType(), cls};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String getDefaultExtension() {
        return this.getDefaultWriter().getDefaultFormatExtension();
    }

    protected String doWrite(T[] conts, T cont) {
        PlaceholderFile file;
        boolean useCompression;
        String result = null;
        String[] ext = this.m_Writer instanceof MetaFileWriter ? ((MetaFileWriter)((Object)this.m_Writer)).getActualFormatExtensions() : this.m_Writer.getFormatExtensions();
        String actualExt = this.getDefaultExtension();
        if (actualExt.endsWith("*")) {
            actualExt = "";
        }
        for (String e : ext) {
            if (e.equals("*")) continue;
            actualExt = e;
            break;
        }
        if (!actualExt.isEmpty() && !actualExt.startsWith(".")) {
            actualExt = "." + actualExt;
        }
        boolean bl = useCompression = this.m_Writer instanceof CompressionSupporter && ((CompressionSupporter)((Object)this.m_Writer)).getUseCompression();
        if (useCompression) {
            actualExt = actualExt + ".gz";
        }
        switch (this.m_FileNameGeneration) {
            case AUTOMATIC: {
                if (this.m_Writer.isOutputFile()) {
                    file = new PlaceholderFile(DataUtils.createFilename((File)this.m_OutputDir, cont, actualExt));
                    break;
                }
                file = new PlaceholderFile(DataUtils.createFilename((File)this.m_OutputDir, cont, null));
                break;
            }
            case DATABASE_ID: {
                if (this.m_Writer.isOutputFile()) {
                    file = new PlaceholderFile(this.m_OutputDir.getAbsolutePath() + File.separator + ((DatabaseIDHandler)cont).getDatabaseID() + actualExt);
                    break;
                }
                file = new PlaceholderFile(this.m_OutputDir.getAbsolutePath() + File.separator + ((DatabaseIDHandler)cont).getDatabaseID());
                break;
            }
            case ID: {
                if (this.m_Writer.isOutputFile()) {
                    file = new PlaceholderFile(this.m_OutputDir.getAbsolutePath() + File.separator + cont.getID() + actualExt);
                    break;
                }
                file = new PlaceholderFile(this.m_OutputDir.getAbsolutePath() + File.separator + cont.getID());
                break;
            }
            case SUPPLIED: {
                file = new PlaceholderFile(this.m_OutputDir.getAbsolutePath() + File.separator + this.m_SuppliedFileName);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled file name generation: " + (Object)((Object)this.m_FileNameGeneration));
            }
        }
        this.m_Writer.setOutput(file);
        try {
            boolean success = conts != null ? this.m_Writer.write(Arrays.asList(conts)) : this.m_Writer.write(cont);
            if (!success) {
                result = "Failed to write data to '" + file + "'!";
            }
            if (this.isLoggingEnabled()) {
                if (conts != null) {
                    this.getLogger().info(conts.length + " containers written to " + file);
                } else if (cont instanceof DatabaseIDHandler) {
                    this.getLogger().info("Container #" + ((DatabaseIDHandler)cont).getDatabaseID() + " written to " + file);
                } else {
                    this.getLogger().info("Container " + cont + " written to " + file);
                }
            }
            this.m_Writer.cleanUp();
            if (success) {
                this.m_OutputToken = new Token(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            result = this.handleException("Error writing container(s) to '" + file + "': ", e);
            return result;
        }
        return result;
    }

    @Override
    protected String doExecute() {
        DataContainer cont;
        DataContainer[] conts;
        if (this.m_InputToken.getPayload().getClass().isArray()) {
            conts = (DataContainer[])this.m_InputToken.getPayload();
            cont = conts[0];
        } else {
            conts = null;
            cont = (DataContainer)this.m_InputToken.getPayload();
        }
        String result = this.doWrite(conts, cont);
        return result;
    }

    public static enum FileNameGeneration {
        AUTOMATIC,
        DATABASE_ID,
        ID,
        SUPPLIED;

    }
}

