/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class Deserialize
extends AbstractTransformer {
    private static final long serialVersionUID = 7491100983182267771L;

    @Override
    public String globalInfo() {
        return "Deserializes a previously serialized Java object from a file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        try {
            Object obj = SerializationHelper.read(file.getAbsolutePath());
            this.m_OutputToken = new Token(obj);
        }
        catch (Exception e) {
            result = this.handleException("Failed to deserialize: " + file, e);
        }
        return result;
    }
}

