/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseDateTime;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.Date;

public class FileInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;
    protected String m_ValueTrue;
    protected String m_ValueFalse;

    @Override
    public String globalInfo() {
        return "Outputs information for a path (file/directory).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.SIZE);
        this.m_OptionManager.add("value-true", "valueTrue", "true");
        this.m_OptionManager.add("value-false", "valueFalse", "false");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "type", (Object)this.m_Type);
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setValueTrue(String value) {
        this.m_ValueTrue = value;
        this.reset();
    }

    public String getValueTrue() {
        return this.m_ValueTrue;
    }

    public String valueTrueTipText() {
        return "The string to output in case query types starting with 'IS_' evaluated to 'true'.";
    }

    public void setValueFalse(String value) {
        this.m_ValueFalse = value;
        this.reset();
    }

    public String getValueFalse() {
        return this.m_ValueFalse;
    }

    public String valueFalseTipText() {
        return "The string to output in case query types starting with 'IS_' evaluated to 'false'.";
    }

    @Override
    public Class[] generates() {
        switch (this.m_Type) {
            case SIZE: {
                return new Class[]{Long.class};
            }
            case LAST_MODIFIED: {
                return new Class[]{BaseDateTime.class};
            }
            case IS_READABLE: 
            case IS_WRITEABLE: 
            case IS_EXECUTABLE: 
            case IS_HIDDEN: 
            case IS_DIRECTORY: 
            case IS_FILE: {
                return new Class[]{String.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    @Override
    public Class[] accepts() {
        return new Class[]{File.class, String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        switch (this.m_Type) {
            case SIZE: {
                this.m_OutputToken = new Token(((File)file).length());
                break;
            }
            case LAST_MODIFIED: {
                this.m_OutputToken = new Token(new BaseDateTime(new Date(((File)file).lastModified())));
                break;
            }
            case IS_READABLE: {
                this.m_OutputToken = new Token(((File)file).canRead() ? this.m_ValueTrue : this.m_ValueFalse);
                break;
            }
            case IS_WRITEABLE: {
                this.m_OutputToken = new Token(((File)file).canWrite() ? this.m_ValueTrue : this.m_ValueFalse);
                break;
            }
            case IS_EXECUTABLE: {
                this.m_OutputToken = new Token(((File)file).canExecute() ? this.m_ValueTrue : this.m_ValueFalse);
                break;
            }
            case IS_HIDDEN: {
                this.m_OutputToken = new Token(((File)file).isHidden() ? this.m_ValueTrue : this.m_ValueFalse);
                break;
            }
            case IS_FILE: {
                this.m_OutputToken = new Token(((File)file).isFile() ? this.m_ValueTrue : this.m_ValueFalse);
                break;
            }
            case IS_DIRECTORY: {
                this.m_OutputToken = new Token(((File)file).isDirectory() ? this.m_ValueTrue : this.m_ValueFalse);
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    public static enum InfoType {
        SIZE,
        LAST_MODIFIED,
        IS_READABLE,
        IS_WRITEABLE,
        IS_EXECUTABLE,
        IS_HIDDEN,
        IS_DIRECTORY,
        IS_FILE;

    }
}

