/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Collections;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class GetJsonKeys
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8757919765508522198L;
    protected boolean m_SortKeys;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sort-keys", "sortKeys", false);
    }

    @Override
    public String globalInfo() {
        return "Outputs all the keys of the JSON Object passing through.";
    }

    @Override
    public String outputArrayTipText() {
        return "If enabled, the keys will get output as array rather than one-by-one.";
    }

    public void setSortKeys(boolean value) {
        this.m_SortKeys = value;
        this.reset();
    }

    public boolean getSortKeys() {
        return this.m_SortKeys;
    }

    public String sortKeysTipText() {
        return "If enabled, the keys will get sorted.";
    }

    @Override
    public String getQuickInfo() {
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.getOutputArray() ? "array" : "one-by-one"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "sortKeys", this.m_SortKeys, "sort keys"));
        String result = QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{JSONAware.class, JSONObject.class};
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    protected String doExecute() {
        String result = null;
        JSONObject json = null;
        if (!(this.m_InputToken.getPayload() instanceof JSONObject)) {
            result = "Input is not of type " + JSONObject.class.getName() + "!";
        } else {
            json = (JSONObject)this.m_InputToken.getPayload();
        }
        if (result == null) {
            this.m_Queue.addAll(json.keySet());
            if (this.m_SortKeys) {
                Collections.sort(this.m_Queue);
            }
        }
        return result;
    }
}

