/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.JsonDataType;
import adams.core.QuickInfoHelper;
import adams.core.base.JsonPathExpression;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class GetJsonValue
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8757919765508522198L;
    protected JsonPathExpression m_Path;
    protected JsonDataType m_DataType;
    protected boolean m_ForwardNull;

    @Override
    public String globalInfo() {
        return "Obtains the value associated with the specified key from the JSON object passing through.\nNull values are only forwarded if requested.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", new JsonPathExpression());
        this.m_OptionManager.add("data-type", "dataType", (Object)JsonDataType.OBJECT);
        this.m_OptionManager.add("forward-null", "forwardNull", false);
    }

    @Override
    protected Class getItemClass() {
        switch (this.m_DataType) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case NUMBER: {
                return Double.class;
            }
            case STRING: {
                return String.class;
            }
            case OBJECT: {
                return JSONObject.class;
            }
            case ARRAY: {
                return JSONArray.class;
            }
        }
        throw new IllegalStateException("Unhandled JSON data type: " + (Object)((Object)this.m_DataType));
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the JSON values as array or one-by-one.";
    }

    public void setPath(JsonPathExpression value) {
        this.m_Path = value;
        this.reset();
    }

    public JsonPathExpression getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The path (or key if not starting with '$') of the value(s) to retrieve.";
    }

    public void setDataType(JsonDataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public JsonDataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "The type of the data that is output.";
    }

    public void setForwardNull(boolean value) {
        this.m_ForwardNull = value;
        this.reset();
    }

    public boolean getForwardNull() {
        return this.m_ForwardNull;
    }

    public String forwardNullTipText() {
        return "If enabled, null values are forward as well.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "path", this.m_Path, "path: ");
        result = result != null ? result + ", " : "";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "dataType", (Object)this.m_DataType, "data-type: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.m_OutputArray, "output array"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "forwardNull", this.m_ForwardNull, "forward null"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{JSONAware.class, JSONObject.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        JSONObject json = null;
        if (!(this.m_InputToken.getPayload() instanceof JSONObject)) {
            result = "Input is not of type " + JSONObject.class.getName() + "!";
        } else {
            json = (JSONObject)this.m_InputToken.getPayload();
        }
        if (result == null) {
            if (this.m_Path.isSimpleKey() || this.m_Path.toJsonPath() == null) {
                if (json.containsKey((Object)this.m_Path.getValue())) {
                    Object val = json.get((Object)this.m_Path.getValue());
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Found value for '" + this.m_Path.getValue() + "': " + val);
                    }
                    if (val instanceof Number) {
                        val = new Double(((Number)val).doubleValue());
                    }
                    if (val != null || this.m_ForwardNull) {
                        this.m_Queue.add(val);
                    }
                } else if (this.isLoggingEnabled()) {
                    this.getLogger().info("No value found for '" + this.m_Path.getValue() + "'!");
                }
            } else {
                JsonPath path = this.m_Path.toJsonPath();
                Object val = path.read((Object)json);
                if (val instanceof List) {
                    this.m_Queue.addAll((List)val);
                } else {
                    this.m_Queue.add(val);
                }
            }
        }
        return result;
    }
}

