/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractNamedSetup;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class NamedSetup
extends AbstractNamedSetup
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 9009691154065525958L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Transformer that executes a transformer specified by the named setup.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    protected String setUpNamedSetupActor() {
        String result = super.setUpNamedSetupActor();
        if (result == null && !ActorUtils.isTransformer(this.m_NamedSetupActor)) {
            result = "Named setup actor referenced by '" + this.m_Setup.getName() + "' is not a transformer!";
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_NamedSetupActor != null) {
            return ((InputConsumer)((Object)this.m_NamedSetupActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    @Override
    public Token currentInput() {
        return this.m_InputToken;
    }

    @Override
    public Class[] generates() {
        if (this.m_NamedSetupActor != null) {
            return ((OutputProducer)((Object)this.m_NamedSetupActor)).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String preExecuteNamedSetupActorHook() {
        ((InputConsumer)((Object)this.m_NamedSetupActor)).input(this.m_InputToken);
        this.m_InputToken = null;
        return null;
    }

    @Override
    public Token output() {
        return ((OutputProducer)((Object)this.m_NamedSetupActor)).output();
    }

    @Override
    public boolean hasPendingOutput() {
        return ((OutputProducer)((Object)this.m_NamedSetupActor)).hasPendingOutput();
    }
}

