/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class ObjectArrayToPrimitiveArray
extends AbstractTransformer {
    private static final long serialVersionUID = 2028596035749723219L;

    @Override
    public String globalInfo() {
        return "Turns an object array into an primitive one. Depending on the input type, either an int or double array.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Byte[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{int[].class, double[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object arrayIn = this.m_InputToken.getPayload();
            int len = Array.getLength(arrayIn);
            Object[] arrayOut = null;
            if (arrayIn instanceof Byte[]) {
                arrayOut = new int[len];
                for (int i = 0; i < len; ++i) {
                    Array.setInt(arrayOut, i, ((Byte)Array.get(arrayIn, i)).byteValue());
                }
            } else if (arrayIn instanceof Short[]) {
                arrayOut = new int[len];
                for (int i = 0; i < len; ++i) {
                    Array.setInt(arrayOut, i, ((Short)Array.get(arrayIn, i)).shortValue());
                }
            } else if (arrayIn instanceof Integer[]) {
                arrayOut = new int[len];
                for (int i = 0; i < len; ++i) {
                    Array.setInt(arrayOut, i, (Integer)Array.get(arrayIn, i));
                }
            } else if (arrayIn instanceof Long[]) {
                arrayOut = new int[len];
                for (int i = 0; i < len; ++i) {
                    Array.setInt(arrayOut, i, ((Long)Array.get(arrayIn, i)).intValue());
                }
            } else if (arrayIn instanceof Float[]) {
                arrayOut = new double[len];
                for (int i = 0; i < len; ++i) {
                    Array.setDouble(arrayOut, i, ((Float)Array.get(arrayIn, i)).floatValue());
                }
            } else if (arrayIn instanceof Double[]) {
                arrayOut = new double[len];
                for (int i = 0; i < len; ++i) {
                    Array.setDouble(arrayOut, i, (Double)Array.get(arrayIn, i));
                }
            } else {
                result = "Unhandled class: " + Utils.classToString(this.m_InputToken.getPayload().getClass());
            }
            if (arrayOut != null) {
                this.m_OutputToken = new Token(arrayOut);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to convert array: ", e);
        }
        return result;
    }
}

