/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.transformer.AbstractArrayProvider;

public class StringJoin
extends AbstractArrayProvider {
    private static final long serialVersionUID = -5524254075032084295L;
    protected String m_Glue;
    protected int m_MaxLength;

    @Override
    public String globalInfo() {
        return "Creates a single string out of an array of strings.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("glue", "glue", "");
        this.m_OptionManager.add("max-length", "maxLength", -1, -1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "glue", this.m_Glue.length() > 0 ? Utils.backQuoteChars(this.m_Glue) : null, "glue: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, "maxLength", this.m_MaxLength > 0 ? Integer.valueOf(this.m_MaxLength) : null, ", max: ");
        if (value != null) {
            result = result == null ? value : result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.m_OutputArray, "as array", ", ")) != null) {
            result = result == null ? value : result + value;
        }
        return result;
    }

    @Override
    public String outputArrayTipText() {
        return "If enabled, the strings are output as an array rather than one-by-one.";
    }

    public void setGlue(String value) {
        this.m_Glue = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getGlue() {
        return Utils.backQuoteChars(this.m_Glue);
    }

    public String glueTipText() {
        return "The string to use for 'glueing' the array elements together; \\t\\n\\r\\b\\f get automatically converted into their character counterparts.";
    }

    public void setMaxLength(int value) {
        if (value >= -1) {
            this.m_MaxLength = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum length must be -1 (unlimited) or greater, provided: " + value);
        }
    }

    public int getMaxLength() {
        return this.m_MaxLength;
    }

    public String maxLengthTipText() {
        return "The maximum length the joined string should not exceed; use -1 for unlimited length.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String[].class};
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            String[] array = (String[])this.m_InputToken.getPayload();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (this.m_MaxLength > -1 && str.length() > 0 && str.length() + this.m_Glue.length() + array[i].length() > this.m_MaxLength) {
                    this.m_Queue.add(str.toString());
                    str.delete(0, str.length());
                }
                if (str.length() > 0) {
                    str.append(this.m_Glue);
                }
                str.append(array[i]);
            }
            this.m_Queue.add(str.toString());
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to join strings: ", e);
        }
        return result;
    }
}

