/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.splitfile;

import adams.core.io.PlaceholderFile;
import adams.flow.transformer.splitfile.AbstractFileSplitter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.logging.Level;

public class SplitBySize
extends AbstractFileSplitter {
    private static final long serialVersionUID = 6675923081135115020L;
    protected long m_MaxSize;

    @Override
    public String globalInfo() {
        return "Splits the file into chunks with the specified maximum size.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-size", "maxSize", 0x100000L, 1L, null);
    }

    public void setMaxSize(long value) {
        if (value > 0L) {
            this.m_MaxSize = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum size must be >0, provided: " + value);
        }
    }

    public long getMaxSize() {
        return this.m_MaxSize;
    }

    public String maxSizeTipText() {
        return "The maximum size of the generated files.";
    }

    @Override
    protected void doSplit(PlaceholderFile file) {
        int bufferSize = (int)Math.min(1024L, this.m_MaxSize);
        char[] buffer = new char[bufferSize];
        try {
            int read;
            FileReader reader = new FileReader(file.getAbsoluteFile());
            OutputStreamWriter writer = null;
            long count = 0L;
            while ((read = reader.read(buffer)) > -1) {
                count += (long)read;
                if (writer == null) {
                    writer = new FileWriter(this.nextFile().getAbsoluteFile());
                }
                if (count >= this.m_MaxSize) {
                    int partial = (int)(this.m_MaxSize - (count - (long)bufferSize));
                    if (count > this.m_MaxSize) {
                        writer.write(buffer, 0, partial);
                    } else {
                        writer.write(buffer, 0, read);
                    }
                    writer.flush();
                    writer.close();
                    writer = null;
                    count = 0L;
                    if (partial >= bufferSize) continue;
                    writer = new FileWriter(this.nextFile().getAbsoluteFile());
                    writer.write(buffer, partial, read - partial);
                    count += (long)(read - partial);
                    continue;
                }
                writer.write(buffer, 0, read);
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            reader.close();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to split file: " + file, e);
        }
    }
}

