/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageReader;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

@MixedCopyright(copyright="1995, 2008, Oracle and/or its affiliates", license=License.BSD3, url="http://docs.oracle.com/javase/tutorial/uiswing/examples/components/FileChooserDemo2Project/src/components/ImagePreview.java")
public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = -2018506061088072140L;
    protected JFileChooser m_Owner;
    protected int m_PreviewWidth;
    protected int m_PreviewHeight;
    protected ImageIcon m_Thumbnail;
    protected File m_File;

    public ImagePreview(JFileChooser owner) {
        this(owner, 100, 50);
    }

    public ImagePreview(JFileChooser owner, int width, int height) {
        this.initialize();
        this.m_Owner = owner;
        this.m_PreviewWidth = width;
        this.m_PreviewHeight = height;
        this.setPreferredSize(new Dimension(this.m_PreviewWidth, this.m_PreviewHeight));
        owner.addPropertyChangeListener(this);
        this.setToolTipText("Click for full size view");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isLeftClick(e)) {
                    ImagePreview.this.showImage();
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    protected void initialize() {
        this.m_Thumbnail = null;
        this.m_File = null;
    }

    public JFileChooser getOwner() {
        return this.m_Owner;
    }

    protected void loadImage() {
        if (this.m_File == null) {
            this.m_Thumbnail = null;
            return;
        }
        ImageIcon tmpIcon = null;
        if (this.m_File.exists() && !this.m_File.isDirectory()) {
            AbstractImageReader reader;
            BufferedImageContainer cont = null;
            if (this.m_Owner instanceof ImageFileChooser && (reader = ((ImageFileChooser)this.m_Owner).getReaderForFile(this.m_File)) != null) {
                cont = reader.read(new PlaceholderFile(this.m_File));
            }
            if (cont == null) {
                cont = BufferedImageHelper.read(this.m_File);
            }
            if (cont != null) {
                tmpIcon = new ImageIcon(((AbstractImageContainer)cont).toBufferedImage());
            }
        }
        if (tmpIcon != null) {
            this.m_Thumbnail = tmpIcon.getIconWidth() > this.m_PreviewWidth - 10 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(this.m_PreviewWidth - 10, -1, 1)) : tmpIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.m_File = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.m_File = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.m_Thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.m_Thumbnail == null) {
            this.loadImage();
        }
        if (this.m_Thumbnail != null) {
            int x = this.getWidth() / 2 - this.m_Thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.m_Thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.m_Thumbnail.paintIcon(this, g, x, y);
        }
    }

    protected void showImage() {
        if (this.m_Thumbnail == null) {
            return;
        }
        ApprovalDialog dialog = GUIHelper.getParentDialog(this) != null ? new ApprovalDialog(GUIHelper.getParentDialog(this), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame(this), true);
        dialog.setTitle(this.m_File.getName());
        dialog.setDefaultCloseOperation(2);
        dialog.setDiscardVisible(false);
        dialog.setCancelVisible(false);
        dialog.setApproveVisible(true);
        dialog.setApproveCaption("Close");
        ImagePanel panel = new ImagePanel();
        panel.getUndo().setEnabled(false);
        panel.load(this.m_File);
        panel.setScale(1.0);
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setSize(800, 600);
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
        dialog.setVisible(true);
    }
}

