/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import adams.gui.visualization.debug.objectexport.PlainTextExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ObjectExporterFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<Object, AbstractObjectExporter> {
    private static final long serialVersionUID = -8442453722350177493L;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    @Override
    protected boolean getFiltersInitialized() {
        return m_WriterFileFilters != null;
    }

    @Override
    protected void doInitializeFilters() {
        ObjectExporterFileChooser.initFilters(AbstractObjectExporter.getExporters());
    }

    protected static void initFilters(String[] classnames) {
        m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        for (String classname : classnames) {
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                desc = ((AbstractObjectExporter)converter).getFormatDescription();
                ext = ((AbstractObjectExporter)converter).getFormatExtensions();
            }
            catch (Exception e) {
                System.err.println("Failed to set up '" + classname + "':");
                e.printStackTrace();
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            ExtensionFileFilterWithClass filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        Collections.sort(m_WriterFileFilters);
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return null;
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    @Override
    protected Object getDefaultReader() {
        return null;
    }

    @Override
    protected Class getReaderClass() {
        return null;
    }

    @Override
    protected AbstractObjectExporter getDefaultWriter() {
        return new PlainTextExporter();
    }

    @Override
    protected Class getWriterClass() {
        return AbstractObjectExporter.class;
    }

    @Override
    protected void initGUI(int dialogType) {
        if (dialogType == 0) {
            throw new IllegalStateException("Open dialog is not supported!");
        }
        super.initGUI(dialogType);
    }
}

