/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.MoveableTableModel;

public abstract class AbstractMoveableTableModel
extends AbstractBaseTableModel
implements MoveableTableModel {
    private static final long serialVersionUID = -6087402226242041322L;

    protected abstract void swap(int var1, int var2);

    protected int[] moveItems(int[] indices, int moveby, boolean up) {
        boolean modified = false;
        if (up) {
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                int newIndex = indices[i] - moveby;
                this.swap(indices[i], newIndex);
                indices[i] = newIndex;
                modified = true;
            }
        } else {
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] == this.getRowCount() - 1) continue;
                int newIndex = indices[i] + moveby;
                this.swap(indices[i], newIndex);
                indices[i] = newIndex;
                modified = true;
            }
        }
        if (modified) {
            this.fireTableDataChanged();
        }
        return indices;
    }

    @Override
    public int[] moveUp(int[] indices) {
        return this.moveItems(indices, 1, true);
    }

    @Override
    public int[] moveDown(int[] indices) {
        return this.moveItems(indices, 1, false);
    }

    @Override
    public int[] moveTop(int[] indices) {
        if (this.canMoveUp(indices)) {
            int diff = indices[0];
            indices = this.moveItems(indices, diff, true);
        }
        return indices;
    }

    @Override
    public int[] moveBottom(int[] indices) {
        if (this.canMoveDown(indices)) {
            int diff = this.getRowCount() - 1 - indices[indices.length - 1];
            indices = this.moveItems(indices, diff, false);
        }
        return indices;
    }

    @Override
    public boolean canMoveUp(int[] indices) {
        boolean result = false;
        if (indices.length > 0 && indices[0] > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean canMoveDown(int[] indices) {
        boolean result = false;
        if (indices.length > 0 && indices[indices.length - 1] < this.getRowCount() - 1) {
            result = true;
        }
        return result;
    }
}

