/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.core.BaseTabbedPane;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@MixedCopyright(author="TERAI Atsuhiro", license=License.PUBLIC_DOMAIN, url="http://java-swing-tips.blogspot.co.nz/2008/04/drag-and-drop-tabs-in-jtabbedpane.html")
public class DragAndDropTabbedPane
extends BaseTabbedPane {
    private static final long serialVersionUID = 4341372770299945895L;
    protected static final int LINEWIDTH = 3;
    protected static final String NAME = "test";
    protected static final int BUTTONSIZE = 30;
    protected static final int RWH = 20;
    protected GhostGlassPane m_GlassPane;
    protected Rectangle m_LineRect;
    protected Color m_LineColor;
    protected int m_DragTabIndex;
    protected static Rectangle m_RectBackward;
    protected static Rectangle m_RectForward;
    protected boolean m_HasGhost;
    protected boolean m_IsPaintScrollArea;

    @Override
    protected void initialize() {
        super.initialize();
        if (m_RectBackward == null) {
            m_RectBackward = new Rectangle();
            m_RectForward = new Rectangle();
        }
        this.m_GlassPane = new GhostGlassPane();
        this.m_LineRect = new Rectangle();
        this.m_LineColor = new Color(0, 100, 255);
        this.m_DragTabIndex = -1;
        this.m_HasGhost = true;
        this.m_IsPaintScrollArea = true;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                DragAndDropTabbedPane.this.m_LineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DragAndDropTabbedPane.this.m_GlassPane.setPoint(new Point(-1000, -1000));
                DragAndDropTabbedPane.this.m_GlassPane.repaint();
            }

            @Override
            public void dragOver(DragSourceDragEvent e) {
                Point glassPt = e.getLocation();
                SwingUtilities.convertPointFromScreen(glassPt, DragAndDropTabbedPane.this.m_GlassPane);
                int targetIdx = DragAndDropTabbedPane.this.getTargetTabIndex(glassPt);
                if (DragAndDropTabbedPane.this.getTabAreaBounds().contains(glassPt) && targetIdx >= 0 && targetIdx != DragAndDropTabbedPane.this.m_DragTabIndex && targetIdx != DragAndDropTabbedPane.this.m_DragTabIndex + 1) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                    DragAndDropTabbedPane.this.m_GlassPane.setCursor(DragSource.DefaultMoveDrop);
                } else {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                    DragAndDropTabbedPane.this.m_GlassPane.setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent e) {
                DragAndDropTabbedPane.this.m_LineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DragAndDropTabbedPane.this.m_DragTabIndex = -1;
                DragAndDropTabbedPane.this.m_GlassPane.setVisible(false);
                if (DragAndDropTabbedPane.this.hasGhost()) {
                    DragAndDropTabbedPane.this.m_GlassPane.setVisible(false);
                    DragAndDropTabbedPane.this.m_GlassPane.setImage(null);
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent e) {
            }
        };
        final Transferable t = new Transferable(){
            protected final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "test");

            @Override
            public Object getTransferData(DataFlavor flavor) {
                return DragAndDropTabbedPane.this;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{this.FLAVOR};
                return f;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getHumanPresentableName().equals(DragAndDropTabbedPane.NAME);
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                if (DragAndDropTabbedPane.this.getTabCount() <= 1) {
                    return;
                }
                Point tabPt = e.getDragOrigin();
                DragAndDropTabbedPane.this.m_DragTabIndex = DragAndDropTabbedPane.this.indexAtLocation(tabPt.x, tabPt.y);
                if (DragAndDropTabbedPane.this.m_DragTabIndex < 0 || !DragAndDropTabbedPane.this.isEnabledAt(DragAndDropTabbedPane.this.m_DragTabIndex)) {
                    return;
                }
                DragAndDropTabbedPane.this.initGlassPane(e.getComponent(), e.getDragOrigin());
                try {
                    e.startDrag(DragSource.DefaultMoveDrop, t, dsl);
                }
                catch (InvalidDnDOperationException idoe) {
                    idoe.printStackTrace();
                }
            }
        };
        new DropTarget(this.m_GlassPane, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dgl);
    }

    protected void clickArrowButton(String actionKey) {
        Action action;
        ActionMap map = this.getActionMap();
        if (map != null && (action = map.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    protected void autoScrollTest(Point glassPt) {
        Rectangle r = this.getTabAreaBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            m_RectBackward.setBounds(r.x, r.y, 20, r.height);
            m_RectForward.setBounds(r.x + r.width - 20 - 30, r.y, 50, r.height);
        } else if (tabPlacement == 2 || tabPlacement == 4) {
            m_RectBackward.setBounds(r.x, r.y, r.width, 20);
            m_RectForward.setBounds(r.x, r.y + r.height - 20 - 30, r.width, 50);
        }
        m_RectBackward = SwingUtilities.convertRectangle(this.getParent(), m_RectBackward, this.m_GlassPane);
        m_RectForward = SwingUtilities.convertRectangle(this.getParent(), m_RectForward, this.m_GlassPane);
        if (m_RectBackward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (m_RectForward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    public void setPaintGhost(boolean flag) {
        this.m_HasGhost = flag;
    }

    public boolean hasGhost() {
        return this.m_HasGhost;
    }

    public void setPaintScrollArea(boolean flag) {
        this.m_IsPaintScrollArea = flag;
    }

    public boolean isPaintScrollArea() {
        return this.m_IsPaintScrollArea;
    }

    protected int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.m_GlassPane, glassPt, this);
        boolean isTB = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            if (isTB) {
                r.setRect(r.x - r.width / 2, r.y, r.width, r.height);
            } else {
                r.setRect(r.x, r.y - r.height / 2, r.width, r.height);
            }
            if (!r.contains(tabPt)) continue;
            return i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        if (isTB) {
            r.setRect(r.x + r.width / 2, r.y, r.width, r.height);
        } else {
            r.setRect(r.x, r.y + r.height / 2, r.width, r.height);
        }
        return r.contains(tabPt) ? this.getTabCount() : -1;
    }

    protected void convertTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this.getComponentAt(prev);
        Component tab = this.getTabComponentAt(prev);
        String str = this.getTitleAt(prev);
        Icon icon = this.getIconAt(prev);
        String tip = this.getToolTipTextAt(prev);
        boolean flg = this.isEnabledAt(prev);
        int tgtindex = prev > next ? next : next - 1;
        this.remove(prev);
        this.insertTab(str, icon, cmp, tip, tgtindex);
        this.setEnabledAt(tgtindex, flg);
        if (flg) {
            this.setSelectedIndex(tgtindex);
        }
        this.setTabComponentAt(tgtindex, tab);
    }

    protected void initTargetLeftRightLine(int next) {
        if (next < 0 || this.m_DragTabIndex == next || next - this.m_DragTabIndex == 1) {
            this.m_LineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.m_GlassPane);
            this.m_LineRect.setRect(r.x - 1, r.y, 3.0, r.height);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.m_GlassPane);
            this.m_LineRect.setRect(r.x + r.width - 1, r.y, 3.0, r.height);
        }
    }

    protected void initTargetTopBottomLine(int next) {
        if (next < 0 || this.m_DragTabIndex == next || next - this.m_DragTabIndex == 1) {
            this.m_LineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.m_GlassPane);
            this.m_LineRect.setRect(r.x, r.y - 1, r.width, 3.0);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.m_GlassPane);
            this.m_LineRect.setRect(r.x, r.y + r.height - 1, r.width, 3.0);
        }
    }

    protected void initGlassPane(Component c, Point tabPt) {
        this.getRootPane().setGlassPane(this.m_GlassPane);
        if (this.hasGhost()) {
            Rectangle rect = this.getBoundsAt(this.m_DragTabIndex);
            BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            rect.x = rect.x < 0 ? 0 : rect.x;
            rect.y = rect.y < 0 ? 0 : rect.y;
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            this.m_GlassPane.setImage(image);
        }
        Point glassPt = SwingUtilities.convertPoint(c, tabPt, this.m_GlassPane);
        this.m_GlassPane.setPoint(glassPt);
        this.m_GlassPane.setVisible(true);
    }

    protected Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        Component comp = this.getSelectedComponent();
        int idx = 0;
        while (comp == null && idx < this.getTabCount()) {
            comp = this.getComponentAt(idx++);
        }
        Rectangle compRect = comp == null ? new Rectangle() : comp.getBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1) {
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 3) {
            tabbedRect.y = tabbedRect.y + compRect.y + compRect.height;
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 2) {
            tabbedRect.width -= compRect.width;
        } else if (tabPlacement == 4) {
            tabbedRect.x = tabbedRect.x + compRect.x + compRect.width;
            tabbedRect.width -= compRect.width;
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }

    protected class GhostGlassPane
    extends JPanel {
        private static final long serialVersionUID = -1731274272252890281L;
        protected final AlphaComposite m_Composite;
        protected Point m_Location = new Point(0, 0);
        protected BufferedImage m_DraggingGhost = null;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.m_Composite = AlphaComposite.getInstance(3, 0.5f);
        }

        public void setImage(BufferedImage draggingGhost) {
            this.m_DraggingGhost = draggingGhost;
        }

        public void setPoint(Point location) {
            this.m_Location = location;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(this.m_Composite);
            if (DragAndDropTabbedPane.this.isPaintScrollArea() && DragAndDropTabbedPane.this.getTabLayoutPolicy() == 1) {
                g2.setPaint(Color.RED);
                g2.fill(m_RectBackward);
                g2.fill(m_RectForward);
            }
            if (this.m_DraggingGhost != null) {
                double xx = this.m_Location.getX() - (double)this.m_DraggingGhost.getWidth(this) / 2.0;
                double yy = this.m_Location.getY() - (double)this.m_DraggingGhost.getHeight(this) / 2.0;
                g2.drawImage((Image)this.m_DraggingGhost, (int)xx, (int)yy, null);
            }
            if (DragAndDropTabbedPane.this.m_DragTabIndex >= 0) {
                g2.setPaint(DragAndDropTabbedPane.this.m_LineColor);
                g2.fill(DragAndDropTabbedPane.this.m_LineRect);
            }
        }
    }

    protected class CDropTargetListener
    implements DropTargetListener {
        protected Point m_glassPt = new Point();

        protected CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Point glassPt = e.getLocation();
            if (DragAndDropTabbedPane.this.getTabPlacement() == 1 || DragAndDropTabbedPane.this.getTabPlacement() == 3) {
                DragAndDropTabbedPane.this.initTargetLeftRightLine(DragAndDropTabbedPane.this.getTargetTabIndex(glassPt));
            } else {
                DragAndDropTabbedPane.this.initTargetTopBottomLine(DragAndDropTabbedPane.this.getTargetTabIndex(glassPt));
            }
            if (DragAndDropTabbedPane.this.hasGhost()) {
                DragAndDropTabbedPane.this.m_GlassPane.setPoint(glassPt);
            }
            if (!this.m_glassPt.equals(glassPt)) {
                DragAndDropTabbedPane.this.m_GlassPane.repaint();
            }
            this.m_glassPt = glassPt;
            DragAndDropTabbedPane.this.autoScrollTest(glassPt);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (this.isDropAcceptable(e)) {
                DragAndDropTabbedPane.this.convertTab(DragAndDropTabbedPane.this.m_DragTabIndex, DragAndDropTabbedPane.this.getTargetTabIndex(e.getLocation()));
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
            DragAndDropTabbedPane.this.repaint();
        }

        protected boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = e.getCurrentDataFlavors();
            return t.isDataFlavorSupported(f[0]) && DragAndDropTabbedPane.this.m_DragTabIndex >= 0;
        }

        protected boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = t.getTransferDataFlavors();
            return t.isDataFlavorSupported(f[0]) && DragAndDropTabbedPane.this.m_DragTabIndex >= 0;
        }
    }
}

