/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetCellRenderer;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.event.PopupMenuListener;
import adams.gui.visualization.core.PopupMenuCustomizer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadSheetTable
extends SortableAndSearchableTable
implements SpreadSheetSupporter {
    private static final long serialVersionUID = 1333317577811620786L;
    protected PopupMenuCustomizer m_HeaderPopupMenuCustomizer;
    protected PopupMenuCustomizer m_CellPopupMenuCustomizer;
    protected SpreadSheetFileChooser m_FileChooser;
    protected HashMap<String, Object> m_LastSetup;

    public SpreadSheetTable(SpreadSheet sheet) {
        this(new SpreadSheetTableModel(sheet));
    }

    public SpreadSheetTable(SpreadSheetTableModel model) {
        super(model);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_HeaderPopupMenuCustomizer = null;
        this.m_CellPopupMenuCustomizer = null;
        this.m_LastSetup = new HashMap();
        this.addHeaderPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                SpreadSheetTable.this.showHeaderPopupMenu(e);
            }
        });
        this.addCellPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                SpreadSheetTable.this.showCellPopupMenu(e);
            }
        });
    }

    protected void setCustomCellRenderer() {
        SpreadSheetCellRenderer renderer = new SpreadSheetCellRenderer();
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(renderer);
        }
    }

    @Override
    public void setModel(TableModel model) {
        SpreadSheetTableModel modelOld = (SpreadSheetTableModel)this.getUnsortedModel();
        TableModelListener[] listeners = null;
        if (modelOld != null) {
            listeners = (TableModelListener[])modelOld.getListeners(TableModelListener.class);
        }
        super.setModel(model);
        this.setCustomCellRenderer();
        if (listeners != null) {
            for (TableModelListener listener : listeners) {
                model.addTableModelListener(listener);
                listener.tableChanged(new TableModelEvent(model));
            }
        }
    }

    @Override
    protected boolean initialUseOptimalColumnWidths() {
        return true;
    }

    @Override
    protected boolean initialSortNewTableModel() {
        return false;
    }

    @Override
    protected Class getTableModelClass() {
        return SpreadSheetTableModel.class;
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new SpreadSheetTableModel();
    }

    public Cell getCellAt(int rowIndex, int columnIndex) {
        SpreadSheetTableModel sheetmodel = (SpreadSheetTableModel)this.getUnsortedModel();
        Cell result = sheetmodel.getCellAt(this.getActualRow(rowIndex), columnIndex);
        return result;
    }

    public void setNumDecimals(int value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNumDecimals(value);
    }

    public int getNumDecimals() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNumDecimals();
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        return this.toSpreadSheet(TableRowRange.ALL);
    }

    public SpreadSheet toSpreadSheet(TableRowRange range) {
        SpreadSheet result;
        SpreadSheet full = ((SpreadSheetTableModel)this.getUnsortedModel()).toSpreadSheet();
        switch (range) {
            case ALL: {
                result = full;
                break;
            }
            case SELECTED: {
                result = full.getHeader();
                int[] indices = this.getSelectedRows();
                for (int i = 0; i < indices.length; ++i) {
                    result.addRow().assign(full.getRow(this.getActualRow(indices[i])));
                }
                break;
            }
            case VISIBLE: {
                result = full.getHeader();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    result.addRow().assign(full.getRow(this.getActualRow(i)));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled row range: " + (Object)((Object)range));
            }
        }
        return result;
    }

    protected synchronized SpreadSheetFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(false);
        }
        return this.m_FileChooser;
    }

    protected void showHeaderPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        int row = this.rowAtPoint(e.getPoint());
        final int col = this.columnAtPoint(e.getPoint());
        final int actCol = this.getShowRowColumn() ? col - 1 : col;
        JMenuItem menuitem = new JMenuItem("Copy column name", GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).toSpreadSheet().getColumnName(actCol));
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy column", GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int actCol = col;
                if (SpreadSheetTable.this.getShowRowColumn()) {
                    --actCol;
                }
                SpreadSheet sheet = ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).toSpreadSheet();
                StringBuilder content = new StringBuilder();
                String sep = System.getProperty("line.separator");
                content.append(sheet.getColumnName(actCol) + sep);
                for (int i = 0; i < sheet.getRowCount(); ++i) {
                    if (!sheet.hasCell(i, actCol) || sheet.getCell(i, actCol).isMissing()) {
                        content.append(sep);
                        continue;
                    }
                    content.append(sheet.getCell(i, actCol).getContent() + sep);
                }
                GUIHelper.copyToClipboard(content.toString());
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Rename column", GUIHelper.getEmptyIcon());
        menuitem.setEnabled(!this.isReadOnly() && (this.getShowRowColumn() && col > 0 || !this.getShowRowColumn()));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).toSpreadSheet();
                boolean readOnly = SpreadSheetTable.this.isReadOnly();
                String newName = sheet.getColumnName(actCol);
                newName = GUIHelper.showInputDialog(SpreadSheetTable.this.getParent(), "Please enter new column name", newName);
                if (newName == null) {
                    return;
                }
                sheet = sheet.getClone();
                sheet.getHeaderRow().getCell(actCol).setContent(newName);
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
                SpreadSheetTable.this.setReadOnly(readOnly);
                SpreadSheetTable.this.setModified(true);
                ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).fireTableDataChanged();
            }
        });
        menu.add(menuitem);
        final boolean asc = !e.isShiftDown();
        menuitem = asc ? new JMenuItem("Sort (asc)", GUIHelper.getIcon("sort-ascending.png")) : new JMenuItem("Sort (desc)", GUIHelper.getIcon("sort-descending.png"));
        menuitem.setEnabled(!this.isReadOnly() && this.getShowRowColumn() && col > 0 || !this.getShowRowColumn());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                boolean readOnly = SpreadSheetTable.this.isReadOnly();
                sheet.sort(actCol, asc);
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
                SpreadSheetTable.this.setReadOnly(readOnly);
                SpreadSheetTable.this.setModified(true);
                ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).fireTableDataChanged();
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Insert column", GUIHelper.getIcon("insert-column.png"));
        menuitem.setEnabled(!this.isReadOnly());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String colName = GUIHelper.showInputDialog(GUIHelper.getParentComponent(SpreadSheetTable.this), "Please enter the name of the column", "New");
                if (colName == null) {
                    return;
                }
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                boolean readOnly = SpreadSheetTable.this.isReadOnly();
                sheet.insertColumn(actCol, colName, "?");
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
                SpreadSheetTable.this.setReadOnly(readOnly);
                SpreadSheetTable.this.setModified(true);
                ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).fireTableDataChanged();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Remove column", GUIHelper.getIcon("delete-column.png"));
        menuitem.setEnabled(!this.isReadOnly());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                boolean readOnly = SpreadSheetTable.this.isReadOnly();
                sheet.removeColumn(actCol);
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
                SpreadSheetTable.this.setReadOnly(readOnly);
                SpreadSheetTable.this.setModified(true);
                ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).fireTableDataChanged();
            }
        });
        menu.add(menuitem);
        SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(this, menu, false, row, actCol);
        if (this.m_HeaderPopupMenuCustomizer != null) {
            this.m_HeaderPopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this.getTableHeader(), e.getX(), e.getY());
    }

    protected void showCellPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        final int col = this.columnAtPoint(e.getPoint());
        final int row = this.rowAtPoint(e.getPoint());
        final int[] rows = this.getSelectedRows().length == 0 ? new int[]{row} : this.getSelectedRows();
        JMenuItem menuitem = this.getSelectedRowCount() > 1 ? new JMenuItem("Copy rows") : new JMenuItem("Copy row");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.copyToClipboard();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy cell");
        menuitem.setIcon(GUIHelper.getEmptyIcon());
        menuitem.setEnabled(this.getSelectedRowCount() == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (row == -1) {
                    return;
                }
                if (col == -1) {
                    return;
                }
                GUIHelper.copyToClipboard("" + SpreadSheetTable.this.getValueAt(row, col));
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem("Insert row", GUIHelper.getIcon("insert-row.png"));
        menuitem.setEnabled(!this.isReadOnly());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                boolean readOnly = SpreadSheetTable.this.isReadOnly();
                sheet.insertRow(row);
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
                SpreadSheetTable.this.setReadOnly(readOnly);
                SpreadSheetTable.this.setModified(true);
                ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).fireTableDataChanged();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Remove row", GUIHelper.getIcon("delete-row.png"));
        menuitem.setEnabled(!this.isReadOnly());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheet sheet = SpreadSheetTable.this.toSpreadSheet();
                boolean readOnly = SpreadSheetTable.this.isReadOnly();
                for (int i = rows.length - 1; i >= 0; --i) {
                    sheet.removeRow(rows[i]);
                }
                SpreadSheetTable.this.setModel(new SpreadSheetTableModel(sheet));
                SpreadSheetTable.this.setReadOnly(readOnly);
                SpreadSheetTable.this.setModified(true);
                ((SpreadSheetTableModel)SpreadSheetTable.this.getUnsortedModel()).fireTableDataChanged();
            }
        });
        menu.add(menuitem);
        menu.addSeparator();
        JMenu submenu = new JMenu("Save");
        submenu.setIcon(GUIHelper.getIcon("save.gif"));
        menu.add(submenu);
        menuitem = new JMenuItem("Save all...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.ALL);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save selected...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.SELECTED);
            }
        });
        submenu.add(menuitem);
        menuitem = new JMenuItem("Save visible...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.saveAs(TableRowRange.VISIBLE);
            }
        });
        submenu.add(menuitem);
        SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(this, menu, true, row, col);
        menu.addSeparator();
        menuitem = new JCheckBoxMenuItem("Show formulas");
        menuitem.setIcon(GUIHelper.getIcon("formula.png"));
        menuitem.setEnabled(this.getRowCount() > 0);
        menuitem.setSelected(this.getShowFormulas());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpreadSheetTable.this.setShowFormulas(!SpreadSheetTable.this.getShowFormulas());
            }
        });
        menu.add(menuitem);
        if (this.m_CellPopupMenuCustomizer != null) {
            this.m_CellPopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this, e.getX(), e.getY());
    }

    public void setHeaderPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_HeaderPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getHeaderPopupMenuCustomizer() {
        return this.m_HeaderPopupMenuCustomizer;
    }

    public void setCellPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_CellPopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getCellPopupMenuCustomizer() {
        return this.m_CellPopupMenuCustomizer;
    }

    public boolean hasNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasNegativeBackground();
    }

    public void setNegativeBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNegativeBackground(value);
    }

    public Color getNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNegativeBackground();
    }

    public boolean hasPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasPositiveBackground();
    }

    public void setPositiveBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setPositiveBackground(value);
    }

    public Color getPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getPositiveBackground();
    }

    public void setShowFormulas(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowFormulas();
    }

    public void setShowRowColumn(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowRowColumn(value);
    }

    public boolean getShowRowColumn() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowRowColumn();
    }

    public void setReadOnly(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setReadOnly(value);
    }

    public boolean isReadOnly() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).isReadOnly();
    }

    public void setModified(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setModified(value);
    }

    public boolean isModified() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).isModified();
    }

    public void sort(RowComparator comparator) {
        this.toSpreadSheet().sort(comparator);
        ((SpreadSheetTableModel)this.getUnsortedModel()).fireTableDataChanged();
    }

    protected void saveAs(TableRowRange range) {
        int retVal = this.getFileChooser().showSaveDialog(GUIHelper.getParentComponent(this));
        if (retVal != 0) {
            return;
        }
        File file = this.getFileChooser().getSelectedFile();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.getFileChooser().getWriter();
        if (!writer.write(this.toSpreadSheet(range), file)) {
            GUIHelper.showErrorMessage(this, "Failed to save spreadsheet to the following file:\n" + file);
        }
    }

    protected String createLastSetupKey(Class cls, boolean plot, boolean row) {
        return cls.getName() + "-" + (plot ? "plot" : "process") + "-" + (row ? "row" : "column");
    }

    public void addLastSetup(Class cls, boolean plot, boolean row, Object setup) {
        this.m_LastSetup.put(this.createLastSetupKey(cls, plot, row), setup);
    }

    public Object getLastSetup(Class cls, boolean plot, boolean row) {
        return this.m_LastSetup.get(this.createLastSetupKey(cls, plot, row));
    }
}

