/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.DateTime;
import adams.core.Time;
import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.ComparableTableModel;
import java.awt.Color;
import java.util.Date;

public class SpreadSheetTableModel
extends AbstractBaseTableModel
implements ComparableTableModel {
    private static final long serialVersionUID = 8062515320279133441L;
    protected SpreadSheet m_Sheet;
    protected int m_NumDecimals;
    protected Color m_BackgroundNegative;
    protected Color m_BackgroundPositive;
    protected boolean m_ShowFormulas;
    protected boolean m_ShowRowColumn;
    protected boolean m_UseSimpleHeader;
    protected boolean m_ReadOnly;
    protected boolean m_Modified;
    protected Cell.ContentType[] m_ColumnType;

    public SpreadSheetTableModel() {
        this(new SpreadSheet());
    }

    public SpreadSheetTableModel(SpreadSheet sheet) {
        this(sheet, -1);
    }

    public SpreadSheetTableModel(SpreadSheet sheet, int numDec) {
        this.m_Sheet = sheet;
        this.m_NumDecimals = numDec;
        this.m_BackgroundNegative = null;
        this.m_BackgroundPositive = null;
        this.m_ShowFormulas = false;
        this.m_ShowRowColumn = true;
        this.m_UseSimpleHeader = false;
        this.m_ReadOnly = true;
        this.m_Modified = false;
        this.m_ColumnType = new Cell.ContentType[sheet.getColumnCount()];
    }

    public void setShowRowColumn(boolean value) {
        this.m_ShowRowColumn = value;
        this.fireTableDataChanged();
    }

    public boolean getShowRowColumn() {
        return this.m_ShowRowColumn;
    }

    public void setUseSimpleHeader(boolean value) {
        this.m_UseSimpleHeader = value;
        this.fireTableStructureChanged();
    }

    public boolean getUseSimpleHeader() {
        return this.m_UseSimpleHeader;
    }

    public void setReadOnly(boolean value) {
        this.m_ReadOnly = value;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    @Override
    public int getRowCount() {
        return this.m_Sheet.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.m_ShowRowColumn) {
            return this.m_Sheet.getColumnCount() + 1;
        }
        return this.m_Sheet.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        if (this.m_ShowRowColumn && columnIndex == 0) {
            result = this.m_UseSimpleHeader ? "Row" : "<html><center>Row<br>1</center></html>";
        } else {
            if (this.m_ShowRowColumn) {
                --columnIndex;
            }
            HeaderRow row = this.m_Sheet.getHeaderRow();
            result = this.m_UseSimpleHeader ? row.getCell(columnIndex).getContent() : "<html><center><b>" + row.getCell(columnIndex).getContent() + "</b>" + "<br>" + SpreadSheet.getColumnPosition(columnIndex) + " / " + (columnIndex + 1) + "</center>" + "</html>";
        }
        return result;
    }

    protected Cell.ContentType determineContentType(int columnIndex) {
        if (this.m_ColumnType[columnIndex] == null) {
            this.m_ColumnType[columnIndex] = this.m_Sheet.isNumeric(columnIndex, true) ? Cell.ContentType.DOUBLE : this.m_Sheet.getContentType(columnIndex);
            if (this.m_ColumnType[columnIndex] == null) {
                this.m_ColumnType[columnIndex] = Cell.ContentType.STRING;
            }
        }
        return this.m_ColumnType[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        if (this.m_ShowRowColumn && columnIndex == 0) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.m_ReadOnly) {
            return false;
        }
        if (this.m_ShowRowColumn) {
            return columnIndex > 0;
        }
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.m_ReadOnly) {
            return;
        }
        if (this.m_ShowRowColumn && columnIndex == 0) {
            return;
        }
        Cell cell = this.getCellAt(rowIndex, columnIndex);
        if (aValue instanceof String) {
            cell.setContent((String)aValue);
        } else {
            cell.setNative(aValue);
        }
        this.m_Modified = true;
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.m_ShowRowColumn && columnIndex == 0) {
            result = new Integer(rowIndex + 2);
        } else {
            DataRow row;
            Cell cell;
            if (this.m_ShowRowColumn) {
                --columnIndex;
            }
            if ((cell = (row = this.m_Sheet.getRow(rowIndex)).getCell(this.m_Sheet.getHeaderRow().getCellKey(columnIndex))) == null) {
                result = null;
            } else if (cell.isMissing()) {
                result = null;
            } else if (cell.isFormula() && this.m_ShowFormulas) {
                result = cell.getFormula();
            } else if (cell.getContentType() == Cell.ContentType.LONG) {
                result = cell.toLong();
            } else if (cell.getContentType() == Cell.ContentType.DOUBLE) {
                double d = cell.toDouble();
                if (Double.isNaN(d)) {
                    result = "NaN";
                } else {
                    if (this.m_NumDecimals > -1) {
                        double factor = Math.pow(10.0, this.m_NumDecimals);
                        d = (double)Math.round(d * factor) / factor;
                    }
                    result = Utils.doubleToStringFixed(d, this.m_NumDecimals);
                }
            } else {
                result = cell.getContent();
            }
        }
        return result;
    }

    public Cell getCellAt(int rowIndex, int columnIndex) {
        Cell result = null;
        if (this.m_ShowRowColumn) {
            --columnIndex;
        }
        if (columnIndex >= 0) {
            result = this.m_Sheet.getCell(rowIndex, columnIndex);
        }
        return result;
    }

    public void setNumDecimals(int value) {
        if (value >= -1) {
            if (this.m_NumDecimals != value) {
                this.m_NumDecimals = value;
                this.fireTableDataChanged();
            }
        } else {
            System.err.println("Number of displayed decimals must be >=0 or -1 to display all - provided: " + value);
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public boolean hasNegativeBackground() {
        return this.m_BackgroundNegative != null;
    }

    public void setNegativeBackground(Color value) {
        this.m_BackgroundNegative = value;
        this.fireTableDataChanged();
    }

    public Color getNegativeBackground() {
        return this.m_BackgroundNegative;
    }

    public boolean hasPositiveBackground() {
        return this.m_BackgroundPositive != null;
    }

    public void setPositiveBackground(Color value) {
        this.m_BackgroundPositive = value;
        this.fireTableDataChanged();
    }

    public Color getPositiveBackground() {
        return this.m_BackgroundPositive;
    }

    public void setShowFormulas(boolean value) {
        if (this.m_ShowFormulas != value) {
            this.m_ShowFormulas = value;
            this.fireTableDataChanged();
        }
    }

    public boolean getShowFormulas() {
        return this.m_ShowFormulas;
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        return this.m_Sheet;
    }

    @Override
    public Class getComparisonColumnClass(int columnIndex) {
        if (this.m_ShowRowColumn && columnIndex == 0) {
            return Integer.class;
        }
        if (this.m_ShowRowColumn) {
            --columnIndex;
        }
        switch (this.determineContentType(columnIndex)) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case LONG: {
                return Long.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case TIME: {
                return Time.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case OBJECT: {
                return Comparable.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getComparisonValueAt(int row, int column) {
        if (this.m_ShowRowColumn && column == 0) {
            return new Integer(row + 2);
        }
        if (this.m_ShowRowColumn) {
            --column;
        }
        if (this.m_Sheet.hasCell(row, column) && !this.m_Sheet.getCell(row, column).isMissing()) {
            return this.m_Sheet.getCell(row, column).getNative();
        }
        return null;
    }

    public SpreadSheetTableModel newModel(SpreadSheet sheet) {
        SpreadSheetTableModel result = new SpreadSheetTableModel(sheet);
        result.setNumDecimals(this.getNumDecimals());
        if (this.hasPositiveBackground()) {
            result.setPositiveBackground(this.getPositiveBackground());
        }
        if (this.hasNegativeBackground()) {
            result.setNegativeBackground(this.getNegativeBackground());
        }
        result.setShowFormulas(this.getShowFormulas());
        result.setShowRowColumn(this.getShowRowColumn());
        result.setUseSimpleHeader(this.getUseSimpleHeader());
        return result;
    }
}

