/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import java.io.File;
import java.io.Serializable;

public class TitleGenerator
implements Serializable {
    private static final long serialVersionUID = 6278140781437652946L;
    protected String m_Title;
    protected boolean m_Split;
    protected boolean m_Enabled;

    public TitleGenerator(String title, boolean split) {
        this.m_Title = title;
        this.m_Split = split;
        this.m_Enabled = true;
    }

    public void setTitle(String value) {
        this.m_Title = value;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public boolean getSplit() {
        return this.m_Split;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public String generate() {
        return this.generate(false);
    }

    public String generate(boolean modified) {
        return this.generate((File)null, modified);
    }

    public String generate(String filename) {
        return this.generate(filename, false);
    }

    public String generate(String filename, boolean modified) {
        if (filename == null) {
            return this.generate((File)null, modified);
        }
        return this.generate(new File(filename), modified);
    }

    public String generate(File file) {
        return this.generate(file, false);
    }

    public String generate(File file, boolean modified) {
        String result = this.m_Title;
        if (file != null) {
            file = new File(file.getAbsolutePath());
            result = this.m_Split ? result + " [" + file.getName() + " -- " + file.getParent() + "]" : result + " [" + file.getAbsolutePath() + "]";
        }
        if (modified) {
            result = "*" + result;
        }
        return result;
    }
}

