/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.ClassLocator;
import adams.core.CloneHandler;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.TempUtils;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Undo {
    public static final int COMMENT_MAX_LENGTH = 40;
    public static final int DEFAULT_MAX_UNDO = 100;
    protected Class m_UndoClass;
    protected boolean m_OnDisk;
    protected List<UndoPoint> m_UndoList;
    protected List<UndoPoint> m_RedoList;
    protected HashSet<UndoListener> m_Listeners;
    protected boolean m_Enabled;
    protected boolean m_Working;
    protected int m_MaxUndo;

    public Undo() {
        this(Object.class);
    }

    public Undo(Class undoClass) {
        this(undoClass, false);
    }

    public Undo(Class undoClass, boolean onDisk) {
        this.m_UndoClass = undoClass;
        this.m_OnDisk = onDisk && ClassLocator.hasInterface(Serializable.class, undoClass);
        this.m_UndoList = new ArrayList<UndoPoint>();
        this.m_RedoList = new ArrayList<UndoPoint>();
        this.m_Listeners = new HashSet();
        this.m_Enabled = true;
        this.m_Working = false;
        this.m_MaxUndo = 100;
    }

    public Class getUndoClass() {
        return this.m_UndoClass;
    }

    public boolean getOnDisk() {
        return this.m_OnDisk;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public synchronized void setMaxUndo(int value) {
        if (value == -1 || value > 0) {
            if (this.m_UndoList.size() == 0 && this.m_RedoList.size() == 0) {
                this.m_MaxUndo = value;
            } else {
                System.err.println("Cannot change undo step limit after undo/redo steps already occurred - ignored!");
            }
        } else {
            System.err.println("Maximum number of undo steps must be >0 or -1 for unlimited, provided: " + value);
        }
    }

    public int getMaxUndo() {
        return this.m_MaxUndo;
    }

    public boolean isWorking() {
        return this.m_Working;
    }

    public boolean addUndo(Object o, String comment) {
        return this.addUndo(o, comment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUndo(Object o, String comment, boolean keepRedo) {
        UndoPoint point;
        boolean result;
        block9: {
            block10: {
                if (!this.isEnabled()) {
                    return false;
                }
                result = true;
                this.m_Working = true;
                if (!this.m_OnDisk) break block10;
                OutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    File file = TempUtils.createTempFile("undo", null);
                    file.deleteOnExit();
                    oos = new ObjectOutputStream(new FileOutputStream(file));
                    oos.writeObject(o);
                    oos.flush();
                    point = new UndoPoint(file, comment);
                    FileUtils.closeQuietly(oos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    point = null;
                    result = false;
                    break block9;
                }
                finally {
                    FileUtils.closeQuietly(oos);
                    FileUtils.closeQuietly(fos);
                }
                FileUtils.closeQuietly(fos);
                break block9;
            }
            point = new UndoPoint(o, comment);
        }
        this.m_UndoList.add(point);
        if (this.m_MaxUndo > 0) {
            while (this.m_UndoList.size() > 1 && this.m_UndoList.size() + this.m_RedoList.size() > this.m_MaxUndo) {
                this.m_UndoList.remove(0);
            }
        }
        if (!keepRedo) {
            this.cleanUp(this.m_RedoList);
        }
        this.m_Working = false;
        this.notifyListeners(new UndoEvent(this, point, UndoEvent.UndoType.ADD_UNDO, result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRedo(Object o, String comment) {
        UndoPoint point;
        boolean result;
        block6: {
            block7: {
                if (!this.isEnabled()) {
                    return false;
                }
                result = true;
                this.m_Working = true;
                if (!this.m_OnDisk) break block7;
                OutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    File file = TempUtils.createTempFile("redo", null);
                    file.deleteOnExit();
                    oos = new ObjectOutputStream(new FileOutputStream(file));
                    oos.writeObject(o);
                    oos.flush();
                    point = new UndoPoint(file, comment);
                    FileUtils.closeQuietly(oos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    point = null;
                    result = false;
                    break block6;
                }
                finally {
                    FileUtils.closeQuietly(oos);
                    FileUtils.closeQuietly(fos);
                }
                FileUtils.closeQuietly(fos);
                break block6;
            }
            point = new UndoPoint(o, comment);
        }
        this.m_RedoList.add(point);
        this.m_Working = false;
        this.notifyListeners(new UndoEvent(this, point, UndoEvent.UndoType.ADD_REDO, result));
        return result;
    }

    public boolean canUndo() {
        return this.isEnabled() && this.m_UndoList.size() > 0 && !this.isWorking();
    }

    public UndoPoint undo() {
        return this.undo(true);
    }

    public UndoPoint peekUndo() {
        return this.m_UndoList.get(this.m_UndoList.size() - 1);
    }

    public String peekUndoComment() {
        return this.peekUndoComment(false);
    }

    public String peekUndoComment(boolean shorten) {
        if (shorten) {
            return this.shortenComment(this.m_UndoList.get(this.m_UndoList.size() - 1).getComment());
        }
        return this.m_UndoList.get(this.m_UndoList.size() - 1).getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoPoint undo(boolean notify) {
        UndoPoint result;
        boolean success;
        block6: {
            block7: {
                success = true;
                this.m_Working = true;
                if (!this.m_OnDisk) break block7;
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                try {
                    UndoPoint point = this.m_UndoList.remove(this.m_UndoList.size() - 1);
                    File file = (File)point.getData();
                    fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    result = new UndoPoint(ois.readObject(), new String(point.getComment()));
                    FileUtils.closeQuietly(ois);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = null;
                    Object point = null;
                    success = false;
                    break block6;
                }
                finally {
                    FileUtils.closeQuietly(ois);
                    FileUtils.closeQuietly(fis);
                }
                FileUtils.closeQuietly(fis);
                break block6;
            }
            result = this.m_UndoList.remove(this.m_UndoList.size() - 1);
        }
        this.m_Working = false;
        if (notify) {
            this.notifyListeners(new UndoEvent(this, result, UndoEvent.UndoType.UNDO, success));
        }
        return result;
    }

    public boolean canRedo() {
        return this.isEnabled() && this.m_RedoList.size() > 0 && !this.isWorking();
    }

    public UndoPoint redo() {
        return this.redo(true);
    }

    public UndoPoint peekRedo() {
        return this.m_RedoList.get(this.m_RedoList.size() - 1);
    }

    public String peekRedoComment() {
        return this.peekRedoComment(false);
    }

    public String peekRedoComment(boolean shorten) {
        if (shorten) {
            return this.shortenComment(this.m_RedoList.get(this.m_RedoList.size() - 1).getComment());
        }
        return this.m_RedoList.get(this.m_RedoList.size() - 1).getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoPoint redo(boolean notify) {
        UndoPoint result;
        boolean success;
        block6: {
            block7: {
                success = true;
                this.m_Working = true;
                if (!this.m_OnDisk) break block7;
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                try {
                    UndoPoint point = this.m_RedoList.remove(this.m_RedoList.size() - 1);
                    File file = (File)point.getData();
                    fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    result = new UndoPoint(ois.readObject(), new String(point.getComment()));
                    ois.close();
                    FileUtils.closeQuietly(ois);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = null;
                    Object point = null;
                    success = false;
                    break block6;
                }
                finally {
                    FileUtils.closeQuietly(ois);
                    FileUtils.closeQuietly(fis);
                }
                FileUtils.closeQuietly(fis);
                break block6;
            }
            result = this.m_RedoList.remove(this.m_RedoList.size() - 1);
        }
        this.m_Working = false;
        if (notify) {
            this.notifyListeners(new UndoEvent(this, result, UndoEvent.UndoType.REDO, success));
        }
        return result;
    }

    protected void cleanUp(List<UndoPoint> list) {
        if (this.m_OnDisk) {
            for (int i = 0; i < list.size(); ++i) {
                UndoPoint point = list.get(i);
                File file = (File)point.getData();
                file.delete();
            }
        }
        list.clear();
    }

    public void clear() {
        this.m_Working = true;
        this.cleanUp(this.m_UndoList);
        this.cleanUp(this.m_RedoList);
        this.m_Working = false;
        this.notifyListeners(new UndoEvent(this, null, UndoEvent.UndoType.CLEAR, true));
    }

    public void addUndoListener(UndoListener l) {
        this.m_Listeners.add(l);
    }

    public void removeUndoListener(UndoListener l) {
        this.m_Listeners.remove(l);
    }

    protected void notifyListeners(UndoEvent e) {
        Iterator<UndoListener> iter = this.m_Listeners.iterator();
        while (iter.hasNext()) {
            iter.next().undoOccurred(e);
        }
    }

    protected String shortenComment(String s) {
        String result = s;
        if (result.length() > 40) {
            result = result.substring(0, 40) + "...";
        }
        return result;
    }

    public static class UndoPoint
    implements Serializable,
    CloneHandler<UndoPoint> {
        private static final long serialVersionUID = -8911750482537649987L;
        protected Object m_Data;
        protected String m_Comment;

        public UndoPoint(Object data, String comment) {
            this.m_Data = data;
            this.m_Comment = comment;
        }

        @Override
        public UndoPoint getClone() {
            return new UndoPoint(Utils.deepCopy(this.m_Data), new String(this.m_Comment));
        }

        public Object getData() {
            return this.m_Data;
        }

        public String getComment() {
            return this.m_Comment;
        }

        public String toString() {
            return this.m_Data.getClass().getName() + " - " + this.getComment();
        }
    }
}

