/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.ProcessColumn;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;

public abstract class AbstractProcessColumn
extends AbstractOptionHandler
implements ProcessColumn {
    private static final long serialVersionUID = -1050881505327794503L;

    @Override
    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    @Override
    public String getIconName() {
        return null;
    }

    protected String check(SpreadSheetTable table, SpreadSheet sheet, int column) {
        if (table == null) {
            return "No source table available!";
        }
        if (sheet == null) {
            return "No spreadsheet available!";
        }
        if (column < 0) {
            return "Negative column index!";
        }
        if (column >= sheet.getColumnCount()) {
            return "Column index too large: " + (column + 1) + " > " + sheet.getColumnCount();
        }
        return null;
    }

    protected abstract boolean doProcessColumn(SpreadSheetTable var1, SpreadSheet var2, int var3);

    @Override
    public boolean processColumn(SpreadSheetTable table, SpreadSheet sheet, int column) {
        boolean result;
        String error = this.check(table, sheet, column);
        boolean bl = result = error == null;
        if (result) {
            result = this.doProcessColumn(table, sheet, column);
        } else {
            GUIHelper.showErrorMessage(table, "Failed to process column #" + (column + 1) + "\n" + error);
        }
        return result;
    }
}

