/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.ProcessRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;

public abstract class AbstractProcessRow
extends AbstractOptionHandler
implements ProcessRow {
    private static final long serialVersionUID = 7979833588446267882L;

    @Override
    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    @Override
    public String getIconName() {
        return null;
    }

    protected String check(SpreadSheetTable table, SpreadSheet sheet, int row) {
        if (table == null) {
            return "No source table available!";
        }
        if (sheet == null) {
            return "No spreadsheet available!";
        }
        if (row < 0) {
            return "Negative row index!";
        }
        if (row >= sheet.getRowCount()) {
            return "Row index too large: " + (row + 1) + " > " + sheet.getRowCount();
        }
        return null;
    }

    protected abstract boolean doProcessRow(SpreadSheetTable var1, SpreadSheet var2, int var3);

    @Override
    public boolean processRow(SpreadSheetTable table, SpreadSheet sheet, int row) {
        boolean result;
        String error = this.check(table, sheet, row);
        boolean bl = result = error == null;
        if (result) {
            result = this.doProcessRow(table, sheet, row);
        } else {
            GUIHelper.showErrorMessage(table, "Failed to process row #" + (row + 1) + "\n" + error);
        }
        return result;
    }
}

