/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.ClassLister;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.PlotColumn;
import adams.gui.core.spreadsheettable.PlotRow;
import adams.gui.core.spreadsheettable.ProcessCell;
import adams.gui.core.spreadsheettable.ProcessColumn;
import adams.gui.core.spreadsheettable.ProcessRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SpreadSheetTablePopupMenuItemHelper {
    protected static List<SpreadSheetTablePopupMenuItem> getItems(Class cls) {
        String[] classes;
        ArrayList<SpreadSheetTablePopupMenuItem> result = new ArrayList<SpreadSheetTablePopupMenuItem>();
        for (String c : classes = ClassLister.getSingleton().getClassnames(cls)) {
            try {
                result.add((SpreadSheetTablePopupMenuItem)Class.forName(c).newInstance());
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Failed to instantiate SpreadSheetTable menu item: " + c + "\n" + e);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    protected static void addAction(final SpreadSheetTable table, final SpreadSheet sheet, boolean isRow, final int row, final int column, JMenuItem menuitem, final SpreadSheetTablePopupMenuItem item) {
        if (isRow) {
            if (item instanceof PlotRow) {
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((PlotRow)item).plotRow(table, sheet, row);
                    }
                });
            } else if (item instanceof ProcessRow) {
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((ProcessRow)item).processRow(table, sheet, row);
                    }
                });
            } else if (item instanceof ProcessCell) {
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((ProcessCell)item).processCell(table, sheet, row, column);
                    }
                });
            }
        } else if (item instanceof PlotColumn) {
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PlotColumn)item).plotColumn(table, sheet, column);
                }
            });
        } else if (item instanceof ProcessColumn) {
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((ProcessColumn)item).processColumn(table, sheet, column);
                }
            });
        }
    }

    protected static void addToPopupMenu(SpreadSheetTable table, boolean isRow, int row, int column, JPopupMenu menu, List<SpreadSheetTablePopupMenuItem> items) {
        if (items.size() == 0) {
            return;
        }
        SpreadSheet sheet = table.toSpreadSheet();
        if (menu.getComponent(menu.getComponentCount() - 1) instanceof JMenuItem) {
            menu.addSeparator();
        }
        for (SpreadSheetTablePopupMenuItem item : items) {
            JMenuItem menuitem = new JMenuItem(item.getMenuItem());
            if (item.getIconName() != null) {
                menuitem.setIcon(GUIHelper.getIcon(item.getIconName()));
            }
            SpreadSheetTablePopupMenuItemHelper.addAction(table, sheet, isRow, row, column, menuitem, item);
            menu.add(menuitem);
        }
    }

    public static void addToPopupMenu(SpreadSheetTable table, JPopupMenu menu, boolean isRow, int row, int column) {
        menu.addSeparator();
        if (isRow) {
            SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(table, true, row, column, menu, SpreadSheetTablePopupMenuItemHelper.getItems(PlotRow.class));
            SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(table, true, row, column, menu, SpreadSheetTablePopupMenuItemHelper.getItems(ProcessRow.class));
            SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(table, true, row, column, menu, SpreadSheetTablePopupMenuItemHelper.getItems(ProcessCell.class));
        } else {
            SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(table, false, row, column, menu, SpreadSheetTablePopupMenuItemHelper.getItems(PlotColumn.class));
            SpreadSheetTablePopupMenuItemHelper.addToPopupMenu(table, false, row, column, menu, SpreadSheetTablePopupMenuItemHelper.getItems(ProcessColumn.class));
        }
    }
}

