/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.menu;

import adams.core.DiffUtils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;
import adams.flow.core.AbstractActor;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.menu.AbstractFlowEditorMenuItemAction;
import adams.gui.visualization.debug.SideBySideDiffPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class EditDiff
extends AbstractFlowEditorMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;

    @Override
    protected String getTitle() {
        return "Show changes";
    }

    protected DiffUtils.SideBySideDiff getDiff() {
        if (!this.canDiff()) {
            return null;
        }
        String current = AbstractOptionProducer.toString(NestedProducer.class, ((FlowEditorPanel)this.m_State).getCurrentFlow()).replace("\t", "  ");
        Vector state = (Vector)((FlowEditorPanel)this.m_State).getCurrentPanel().getUndo().peekUndo().getData();
        if (state.get(0) == null) {
            return null;
        }
        AbstractActor actor = state.get(0) instanceof AbstractActor ? (AbstractActor)state.get(0) : (AbstractActor)AbstractOptionConsumer.consume(NestedConsumer.class, state.get(0));
        String prev = AbstractOptionProducer.toString(NestedProducer.class, actor).replace("\t", "  ");
        DiffUtils.SideBySideDiff result = DiffUtils.sideBySide(prev.split("\n"), current.split("\n"));
        return result;
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        if (!this.canDiff()) {
            return;
        }
        DiffUtils.SideBySideDiff diff = this.getDiff();
        if (diff == null) {
            GUIHelper.showErrorMessage((Component)this.m_State, "Failed to compute differences!");
            return;
        }
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Differences");
        dialog.setCancelVisible(false);
        dialog.setApproveCaption("Close");
        dialog.setApproveMnemonic(108);
        SideBySideDiffPanel panel = new SideBySideDiffPanel();
        panel.setLabelText(true, "Previous");
        panel.setLabelText(false, "Current");
        panel.display(diff);
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setSize(800, 600);
        dialog.setLocationRelativeTo((Component)this.m_State);
        dialog.setVisible(true);
    }

    protected boolean canDiff() {
        return ((FlowEditorPanel)this.m_State).getCurrentPanel().getUndo().isEnabled() && !((FlowEditorPanel)this.m_State).getCurrentPanel().getUndo().isWorking() && ((FlowEditorPanel)this.m_State).getCurrentPanel().getUndo().canUndo();
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((FlowEditorPanel)this.m_State).hasCurrentPanel() && this.isInputEnabled() && this.canDiff());
    }
}

