/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.io.FlowFile;
import adams.flow.core.ExternalActorHandler;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.FlowEditorDialog;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class EditExternalFlow
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Edit...";
    }

    @Override
    protected void doUpdate() {
        boolean enabled;
        boolean bl = enabled = ((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).isSingleSel && ((StateContainer)this.m_State).selNode.getActor() instanceof ExternalActorHandler;
        if (enabled) {
            FlowFile file = ((ExternalActorHandler)((Object)((StateContainer)this.m_State).selNode.getActor())).getActorFile();
            enabled = file.exists() && !file.isDirectory();
        }
        this.setEnabled(enabled);
    }

    protected void editFlow(TreePath path) {
        Node node = TreeHelper.pathToNode(path);
        if (node == null) {
            return;
        }
        ExternalActorHandler actor = (ExternalActorHandler)((Object)node.getActor());
        if (actor == null) {
            return;
        }
        FlowEditorDialog dialog = this.getParentDialog() != null ? new FlowEditorDialog(this.getParentDialog()) : new FlowEditorDialog(this.getParentFrame());
        dialog.getFlowEditorPanel().loadUnsafe(actor.getActorFile());
        dialog.setVisible(true);
        if (!(dialog.getFlowEditorPanel().getCurrentFile() == null || actor.getActorFile() != null && actor.getActorFile().equals(dialog.getFlowEditorPanel().getCurrentFile()))) {
            actor.setActorFile(new FlowFile(dialog.getFlowEditorPanel().getCurrentFile()));
            ((StateContainer)this.m_State).tree.setModified(true);
        }
        node.collapse();
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, node, ActorChangeEvent.Type.MODIFY));
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.editFlow(((StateContainer)this.m_State).selPath);
    }
}

