/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.ClassLocator;
import adams.core.VariableName;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHandler;
import adams.flow.processor.ListCallableActorUsage;
import adams.flow.processor.ListStorageUsage;
import adams.flow.processor.ListVariableUsage;
import adams.gui.action.AbstractPropertiesAction;
import adams.gui.core.GUIHelper;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.menu.AbstractTreePopupSubMenuAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class FindUsages
extends AbstractTreePopupSubMenuAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Find usages";
    }

    protected String getCallableActorName(Actor actor, Actor parent) {
        if (parent != null && parent instanceof CallableActorHandler) {
            return actor.getName();
        }
        return null;
    }

    protected List<String> findVariableNames(Actor actor) {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractOption option : actor.getOptionManager().getOptionsList()) {
            String name;
            if (!(option instanceof AbstractArgumentOption)) continue;
            AbstractArgumentOption arg = (AbstractArgumentOption)option;
            if (arg.isVariableAttached() && !result.contains(name = arg.getVariableName())) {
                result.add(name);
            }
            if (!ClassLocator.isSubclass(VariableName.class, arg.getBaseClass())) continue;
            if (arg.isMultiple()) {
                Object array = arg.getCurrentValue();
                for (int i = 0; i < Array.getLength(array); ++i) {
                    name = ((VariableName)Array.get(array, i)).getValue();
                    if (result.contains(name)) continue;
                    result.add(name);
                }
                continue;
            }
            name = ((VariableName)arg.getCurrentValue()).getValue();
            if (result.contains(name)) continue;
            result.add(name);
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    protected List<String> findStorageNames(Actor actor) {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractOption option : actor.getOptionManager().getOptionsList()) {
            String name;
            AbstractArgumentOption arg;
            if (!(option instanceof AbstractArgumentOption) || !ClassLocator.isSubclass(StorageName.class, (arg = (AbstractArgumentOption)option).getBaseClass())) continue;
            if (arg.isMultiple()) {
                Object array = arg.getCurrentValue();
                for (int i = 0; i < Array.getLength(array); ++i) {
                    name = ((StorageName)Array.get(array, i)).getValue();
                    if (result.contains(name)) continue;
                    result.add(name);
                }
                continue;
            }
            name = ((StorageName)arg.getCurrentValue()).getValue();
            if (result.contains(name)) continue;
            result.add(name);
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    @Override
    protected AbstractPropertiesAction[] getSubMenuActions() {
        return null;
    }

    protected JMenuItem createCallableActorMenuItem(final String callable) {
        JMenuItem result = new JMenuItem(callable);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListCallableActorUsage processor = new ListCallableActorUsage();
                processor.setName(callable);
                ((StateContainer)((FindUsages)FindUsages.this).m_State).tree.getOwner().processActors(processor);
            }
        });
        return result;
    }

    protected JMenuItem createVariableMenuItem(final String variable) {
        JMenuItem result = new JMenuItem(variable);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListVariableUsage processor = new ListVariableUsage();
                processor.setName(variable);
                ((StateContainer)((FindUsages)FindUsages.this).m_State).tree.getOwner().processActors(processor);
            }
        });
        return result;
    }

    protected JMenuItem createStorageMenuItem(final String storage) {
        JMenuItem result = new JMenuItem(storage);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListStorageUsage processor = new ListStorageUsage();
                processor.setName(storage);
                ((StateContainer)((FindUsages)FindUsages.this).m_State).tree.getOwner().processActors(processor);
            }
        });
        return result;
    }

    @Override
    public JMenu createMenu() {
        JMenu result;
        block15: {
            List<String> items;
            List<String> vars;
            String callable;
            block14: {
                JMenu submenu;
                result = new JMenu(this.getName());
                if (this.getIcon() != null) {
                    result.setIcon(this.getIcon());
                } else {
                    result.setIcon(GUIHelper.getEmptyIcon());
                }
                AbstractActor actor = ((StateContainer)this.m_State).selNode.getActor();
                AbstractActor parent = ((StateContainer)this.m_State).parent != null ? ((StateContainer)this.m_State).parent.getActor() : null;
                callable = this.getCallableActorName(actor, parent);
                vars = this.findVariableNames(actor);
                items = this.findStorageNames(actor);
                int count = 0;
                if (callable != null) {
                    ++count;
                }
                if (vars.size() > 0) {
                    ++count;
                }
                if (items.size() > 0) {
                    ++count;
                }
                if (count <= 1) break block14;
                if (callable != null) {
                    submenu = new JMenu("Callable actor");
                    result.add(submenu);
                    submenu.add(this.createCallableActorMenuItem(callable));
                }
                if (items.size() > 0) {
                    submenu = new JMenu("Storage item");
                    result.add(submenu);
                    for (String item : items) {
                        submenu.add(this.createStorageMenuItem(item));
                    }
                }
                if (vars.size() <= 0) break block15;
                submenu = new JMenu("Variable");
                result.add(submenu);
                for (String var : vars) {
                    submenu.add(this.createVariableMenuItem(var));
                }
                break block15;
            }
            if (callable != null) {
                result.add(this.createCallableActorMenuItem(callable));
            }
            if (items.size() > 0) {
                for (String item : items) {
                    result.add(this.createStorageMenuItem(item));
                }
            }
            if (vars.size() > 0) {
                for (String var : vars) {
                    result.add(this.createVariableMenuItem(var));
                }
            }
        }
        return result;
    }

    @Override
    protected void doUpdate() {
        boolean enabled = false;
        if (((StateContainer)this.m_State).isSingleSel) {
            AbstractActor actor = ((StateContainer)this.m_State).selNode.getActor();
            AbstractActor parent = ((StateContainer)this.m_State).parent != null ? ((StateContainer)this.m_State).parent.getActor() : null;
            enabled = this.getCallableActorName(actor, parent) != null || this.findVariableNames(actor).size() > 0 || this.findStorageNames(actor).size() > 0;
        }
        this.setEnabled(enabled);
    }
}

