/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.flow.core.ActorPath;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.MouseUtils;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.FlowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ActorPathEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected JTextField m_TextValue;
    protected Tree m_Tree;

    public static String toString(AbstractOption option, Object object) {
        return ((ActorPath)object).toString();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new ActorPath(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return ActorPathEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return new ActorPath(str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + ActorPath.class.getName() + "(\"" + Utils.backQuoteChars(this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected ActorPath parse(String s) {
        ActorPath result;
        try {
            result = new ActorPath(s);
            if (!result.toString().equals(s)) {
                result = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelTree = new JPanel(new BorderLayout(0, 5));
        panelTree.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panelTree.setPreferredSize(new Dimension(600, 600));
        this.m_Tree = new Tree(null);
        this.m_Tree.setAllowNodePopup(false);
        this.m_Tree.setAllowKeyboardShortcuts(false);
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ActorPathEditor.this.m_Tree.getSelectedFullName() != null) {
                    ActorPathEditor.this.m_TextValue.setText(ActorPathEditor.this.m_Tree.getSelectedFullName());
                } else {
                    ActorPathEditor.this.m_TextValue.setText("");
                }
            }
        });
        this.m_Tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MouseUtils.isDoubleClick(e) && ActorPathEditor.this.m_Tree.getSelectedFullName() != null) {
                    ActorPathEditor.this.m_TextValue.setText(ActorPathEditor.this.m_Tree.getSelectedFullName());
                    e.consume();
                }
                if (!e.isConsumed()) {
                    super.mousePressed(e);
                }
            }
        });
        panelTree.add((Component)new BaseScrollPane(this.m_Tree), "Center");
        panelTree.add((Component)new JLabel("Select actor:"), "North");
        JPanel panelAll = new JPanel(new BorderLayout());
        panelTree.add((Component)panelAll, "South");
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        this.m_TextValue = new JTextField(20);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ActorPathEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    ActorPathEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Manual reference");
        label.setDisplayedMnemonic('M');
        label.setLabelFor(this.m_TextValue);
        panel.add(label);
        panel.add(this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorPathEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorPathEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelTree;
    }

    protected boolean isValid(String s) {
        return this.parse(s) != null;
    }

    protected boolean isUnchanged(String s) {
        return s.equals(this.getValue().toString());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    @Override
    protected void initForDisplay() {
        Tree tree;
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        if ((tree = FlowHelper.getTree(this.m_CustomEditor)) != null) {
            this.m_Tree.setActor(tree.getActor());
            if (!this.m_TextValue.getText().isEmpty()) {
                this.m_Tree.locateAndDisplay(this.m_TextValue.getText());
            }
        }
        this.m_TextValue.grabFocus();
    }
}

