/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseColor;
import adams.core.option.AbstractOption;
import adams.gui.core.BasePanel;
import adams.gui.core.ColorHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseColorEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JColorChooser m_ColorChooser;
    protected JSpinner m_SpinnerAlpha;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseColor)object).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseColor(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseColorEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return BaseColorEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        return "null";
    }

    protected Color getColor() {
        Color current = this.m_ColorChooser.getColor();
        int alpha = (Integer)this.m_SpinnerAlpha.getValue();
        Color result = new Color(current.getRed(), current.getGreen(), current.getBlue(), alpha);
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        BaseColor currentColor = (BaseColor)this.getValue();
        BasePanel result = new BasePanel(new BorderLayout());
        JPanel panelColor = new JPanel(new BorderLayout());
        result.add((Component)panelColor, "Center");
        this.m_ColorChooser = new JColorChooser();
        this.m_ColorChooser.setColor(currentColor.toColorValue());
        panelColor.add((Component)this.m_ColorChooser, "Center");
        JPanel panelAlpha = new JPanel(new FlowLayout(0));
        panelColor.add((Component)panelAlpha, "South");
        this.m_SpinnerAlpha = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerAlpha.getModel()).setMinimum(Integer.valueOf(0));
        ((SpinnerNumberModel)this.m_SpinnerAlpha.getModel()).setMaximum(Integer.valueOf(255));
        ((SpinnerNumberModel)this.m_SpinnerAlpha.getModel()).setValue(currentColor.toColorValue().getAlpha());
        this.m_SpinnerAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Color newColor = BaseColorEditor.this.getColor();
                BaseColorEditor.this.m_ColorChooser.setColor(newColor);
            }
        });
        JLabel labelAlpha = new JLabel("Alpha");
        labelAlpha.setDisplayedMnemonic('A');
        labelAlpha.setLabelFor(this.m_SpinnerAlpha);
        panelAlpha.add(labelAlpha);
        panelAlpha.add(this.m_SpinnerAlpha);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        result.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseColorEditor.this.setValue(new BaseColor(BaseColorEditor.this.getColor()));
                BaseColorEditor.this.closeDialog(1);
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setMnemonic('C');
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseColorEditor.this.closeDialog(0);
            }
        });
        panelButtons.add(buttonCancel);
        return result;
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        BaseColor currentColor = (BaseColor)this.getValue();
        if (currentColor != null) {
            this.m_ColorChooser.setColor(currentColor.toColorValue());
            this.m_SpinnerAlpha.setValue(currentColor.toColorValue().getAlpha());
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        BaseColor color = (BaseColor)this.getValue();
        String val = "No color";
        if (color != null) {
            val = BaseColorEditor.toString(null, color);
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the colors (#RRGGBB; #AARRGGBB; R,G,B; A,R,G,B), one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(BaseColor.class, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, new BaseColor(lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(BaseColor.class, 0);
        }
        return result;
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    protected boolean isValid(String s) {
        return ColorHelper.valueOf(s, null) != null;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isValid(value)) {
            this.setValue(new BaseColor(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((BaseColor)this.getValue()).getValue();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return this.isValid(value);
    }
}

