/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.base.BaseBoolean;
import adams.core.base.BaseByte;
import adams.core.base.BaseCharacter;
import adams.core.base.BaseDouble;
import adams.core.base.BaseFloat;
import adams.core.base.BaseInteger;
import adams.core.base.BaseLong;
import adams.core.base.BaseObject;
import adams.core.base.BaseShort;
import adams.core.base.BaseString;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericArrayEditor;
import adams.gui.goe.GenericArrayEditorDialog;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.goe.PropertyPanel;
import adams.gui.goe.PropertyText;
import adams.gui.goe.PropertyValueSelector;
import java.awt.Container;
import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.JComponent;

public class EditorHelper {
    public static JComponent findView(PropertyEditor editor) {
        JComponent result = null;
        if (editor.supportsCustomEditor() && editor.isPaintable()) {
            result = new PropertyPanel(editor);
        } else if (editor.supportsCustomEditor() && editor.getCustomEditor() instanceof JComponent) {
            result = (JComponent)editor.getCustomEditor();
        } else if (editor.getTags() != null) {
            result = new PropertyValueSelector(editor);
        } else if (editor.getAsText() != null) {
            result = new PropertyText(editor);
        }
        return result;
    }

    public static boolean isPrimitive(Class cls) {
        if (cls == Boolean.class) {
            return true;
        }
        if (cls == Character.class) {
            return true;
        }
        if (cls == String.class) {
            return true;
        }
        if (cls == Byte.class) {
            return true;
        }
        if (cls == Short.class) {
            return true;
        }
        if (cls == Integer.class) {
            return true;
        }
        if (cls == Long.class) {
            return true;
        }
        if (cls == Float.class) {
            return true;
        }
        return cls == Double.class;
    }

    public static Class getWrapperClass(Class cls) {
        if (cls == Boolean.class) {
            return BaseBoolean.class;
        }
        if (cls == Character.class) {
            return BaseCharacter.class;
        }
        if (cls == String.class) {
            return BaseString.class;
        }
        if (cls == Byte.class) {
            return BaseByte.class;
        }
        if (cls == Short.class) {
            return BaseShort.class;
        }
        if (cls == Integer.class) {
            return BaseInteger.class;
        }
        if (cls == Long.class) {
            return BaseLong.class;
        }
        if (cls == Float.class) {
            return BaseFloat.class;
        }
        if (cls == Double.class) {
            return BaseDouble.class;
        }
        return null;
    }

    public static Class getPrimitiveClass(Class cls) {
        if (cls == BaseBoolean.class) {
            return Boolean.class;
        }
        if (cls == BaseCharacter.class) {
            return Character.class;
        }
        if (cls == BaseString.class) {
            return String.class;
        }
        if (cls == BaseByte.class) {
            return Byte.class;
        }
        if (cls == BaseShort.class) {
            return Short.class;
        }
        if (cls == BaseInteger.class) {
            return Integer.class;
        }
        if (cls == BaseLong.class) {
            return Long.class;
        }
        if (cls == BaseFloat.class) {
            return Float.class;
        }
        if (cls == BaseDouble.class) {
            return Double.class;
        }
        return null;
    }

    public static boolean isPrimitive(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Short) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        return obj instanceof Double;
    }

    public static BaseObject wrapPrimitive(Object obj) {
        if (obj instanceof Boolean) {
            return new BaseBoolean((Boolean)obj);
        }
        if (obj instanceof Character) {
            return new BaseCharacter((Character)obj);
        }
        if (obj instanceof String) {
            return new BaseString((String)obj);
        }
        if (obj instanceof Byte) {
            return new BaseByte((Byte)obj);
        }
        if (obj instanceof Short) {
            return new BaseShort((Short)obj);
        }
        if (obj instanceof Integer) {
            return new BaseInteger((Integer)obj);
        }
        if (obj instanceof Long) {
            return new BaseLong((Long)obj);
        }
        if (obj instanceof Float) {
            return new BaseFloat((Float)obj);
        }
        if (obj instanceof Double) {
            return new BaseDouble((Double)obj);
        }
        return null;
    }

    public static Object unwrapPrimitive(Object obj) {
        if (obj instanceof BaseBoolean) {
            return ((BaseBoolean)obj).booleanValue();
        }
        if (obj instanceof BaseCharacter) {
            return Character.valueOf(((BaseCharacter)obj).charValue());
        }
        if (obj instanceof BaseString) {
            return ((BaseString)obj).stringValue();
        }
        if (obj instanceof BaseByte) {
            return ((BaseByte)obj).byteValue();
        }
        if (obj instanceof BaseShort) {
            return ((BaseShort)obj).shortValue();
        }
        if (obj instanceof BaseInteger) {
            return ((BaseInteger)obj).intValue();
        }
        if (obj instanceof BaseLong) {
            return ((BaseLong)obj).longValue();
        }
        if (obj instanceof BaseFloat) {
            return Float.valueOf(((BaseFloat)obj).floatValue());
        }
        if (obj instanceof BaseDouble) {
            return ((BaseDouble)obj).doubleValue();
        }
        return null;
    }

    public static Object simpleEdit(Container parent, Object obj, String title) {
        Object result;
        if (obj == null) {
            return null;
        }
        boolean primitive = EditorHelper.isPrimitive(obj);
        if (primitive && (obj = EditorHelper.wrapPrimitive(obj)) == null) {
            return null;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(obj.getClass());
        if (editor instanceof GenericObjectEditor) {
            GenericObjectEditorDialog dialogGOE = GUIHelper.getParentDialog(parent) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog(parent), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame(parent), true);
            dialogGOE.setTitle(title);
            dialogGOE.getGOEEditor().setClassType(obj.getClass());
            dialogGOE.getGOEEditor().setCanChangeClassInDialog(false);
            dialogGOE.setCurrent(obj);
            dialogGOE.pack();
            dialogGOE.setLocationRelativeTo(dialogGOE.getParent());
            dialogGOE.setVisible(true);
            if (dialogGOE.getResult() != 0) {
                return null;
            }
            result = dialogGOE.getCurrent();
        } else if (editor instanceof GenericArrayEditor || obj.getClass().isArray()) {
            GenericArrayEditorDialog dialogArray = GUIHelper.getParentDialog(parent) != null ? new GenericArrayEditorDialog(GUIHelper.getParentDialog(parent), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericArrayEditorDialog(GUIHelper.getParentFrame(parent), true);
            dialogArray.setTitle(title);
            dialogArray.setCurrent(obj);
            dialogArray.pack();
            dialogArray.setLocationRelativeTo(dialogArray.getParent());
            dialogArray.setVisible(true);
            if (dialogArray.getResult() != 0) {
                return null;
            }
            result = dialogArray.getCurrent();
        } else {
            GenericObjectEditorDialog dialogGOE = GUIHelper.getParentDialog(parent) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog(parent), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame(parent), true);
            dialogGOE.setTitle(title);
            editor.setValue(obj);
            dialogGOE.setEditor(editor);
            dialogGOE.pack();
            dialogGOE.setLocationRelativeTo(dialogGOE.getParent());
            dialogGOE.setVisible(true);
            if (dialogGOE.getResult() != 0) {
                return null;
            }
            result = editor.getValue();
        }
        if (primitive) {
            result = EditorHelper.unwrapPrimitive(result);
        }
        return result;
    }
}

