/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.EnumHelper;
import adams.core.option.EnumOption;
import adams.gui.core.BaseList;
import adams.gui.core.BaseScrollPane;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.goe.Editors;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.HashSet;

public class EnumEditor
extends PropertyEditorSupport
implements MultiSelectionEditor {
    protected static HashSet<Class> m_Registered = new HashSet();

    @Override
    public String getJavaInitializationString() {
        String result = "Enum.valueOf(" + this.getValue().getClass().getSimpleName() + ", " + this.getValue().toString() + ")";
        return result;
    }

    @Override
    public String getAsText() {
        return this.getValue().toString();
    }

    @Override
    public void setAsText(String text) {
        this.setValue(EnumHelper.parse(this.getValue().getClass(), text));
    }

    @Override
    public String[] getTags() {
        Object[] values = EnumHelper.getValues(this.getValue());
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].toString();
        }
        return result;
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Class cls = EnumHelper.determineClass(this.getValue());
        BaseList list = new BaseList(EnumHelper.getValues(cls));
        list.setSelectionMode(2);
        ApprovalDialog dialog = new ApprovalDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.getContentPane().add((Component)new BaseScrollPane(list), "Center");
        dialog.pack();
        dialog.setTitle(cls.getSimpleName());
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        Object[] result = dialog.getOption() == 0 ? list.getSelectedValuesList().toArray() : (Object[])Array.newInstance(cls, 0);
        return result;
    }

    public static void registerEditor(EnumOption option) {
        Class cls = option.getBaseClass();
        if (!m_Registered.contains(cls)) {
            Editors.registerCustomEditor(cls, EnumEditor.class);
            m_Registered.add(cls);
        }
    }
}

