/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericArrayEditorDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;

public class GenericArrayEditorPanel
extends AbstractChooserPanel {
    private static final long serialVersionUID = -2499362435055386967L;
    protected GenericArrayEditorDialog m_Dialog;
    protected Object m_Default;
    protected Object m_Current;
    protected int m_MaxDisplayItems;

    public GenericArrayEditorPanel(Object defValue) {
        this.m_Default = defValue;
        this.setCurrent(defValue);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_MaxDisplayItems = 1;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_TextSelection.setEditable(false);
    }

    protected Object doChoose() {
        if (this.m_Dialog == null) {
            this.m_Dialog = GenericArrayEditorDialog.createDialog(this, this.getCurrent());
            this.m_Dialog.getEditor().addOkListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GenericArrayEditorPanel.this.isEditable()) {
                        GenericArrayEditorPanel.this.setCurrent(GenericArrayEditorPanel.this.m_Dialog.getEditor().getValue());
                        GenericArrayEditorPanel.this.notifyChangeListeners(new ChangeEvent(GenericArrayEditorPanel.this.m_Self));
                    }
                }
            });
            this.m_Dialog.getEditor().addCancelListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericArrayEditorPanel.this.m_Dialog.getEditor().setValue(GenericArrayEditorPanel.this.getCurrent());
                    GenericArrayEditorPanel.this.notifyChangeListeners(new ChangeEvent(GenericArrayEditorPanel.this.m_Self));
                }
            });
        }
        if (this.hasValue()) {
            this.m_Dialog.getEditor().setValue(this.getCurrent());
        }
        this.m_Dialog.setLocationRelativeTo(this);
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getResult() == 0) {
            return this.m_Dialog.getEditor().getValue();
        }
        return null;
    }

    @Override
    public boolean hasValue() {
        return this.m_Current != null;
    }

    protected void updateDisplay() {
        String display = "";
        if (this.m_Current != null) {
            if (Array.getLength(this.m_Current) <= this.m_MaxDisplayItems) {
                for (int i = 0; i < Array.getLength(this.m_Current); ++i) {
                    if (i > 0) {
                        display = display + ", ";
                    }
                    display = display + Array.get(this.m_Current, i);
                }
            } else {
                display = Array.getLength(this.m_Current) + " " + this.m_Current.getClass().getComponentType().getName();
            }
        }
        this.m_TextSelection.setText(display);
    }

    public boolean setCurrent(Object value) {
        this.m_Current = value == null ? Utils.deepCopy(this.m_Default) : Utils.deepCopy(value);
        this.updateDisplay();
        return true;
    }

    public Object getCurrent() {
        return this.m_Current;
    }

    protected Object fromString(String value) {
        return null;
    }

    protected String toString(Object value) {
        return null;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = this.isEditable() ? new JMenuItem("Edit...", GUIHelper.getIcon("properties.gif")) : new JMenuItem("Show...", GUIHelper.getIcon("properties.gif"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditorPanel.this.choose();
            }
        });
        menu.add(item);
        return menu;
    }

    public void setMaxDisplayItems(int value) {
        if (value >= 0) {
            this.m_MaxDisplayItems = value;
            this.updateDisplay();
        }
    }

    public int getMaxDisplayItems() {
        return this.m_MaxDisplayItems;
    }
}

