/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.management.ProcessUtils;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextDialog;
import adams.gui.menu.AbstractJDKMenuItemDefinition;
import javax.swing.SwingWorker;

public class JMap
extends AbstractJDKMenuItemDefinition {
    private static final long serialVersionUID = -1502903491659697700L;

    public JMap() {
        this(null);
    }

    public JMap(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void doLaunch() {
        String options = GUIHelper.showInputDialog(this.getOwner(), "Enter the options for jmap:", adams.core.management.JMap.getDefaultOptions());
        if (options == null) {
            return;
        }
        final long fPid = ProcessUtils.getVirtualMachinePID();
        final String fOptions = options;
        SwingWorker worker = new SwingWorker(){
            protected String m_Output = null;

            protected Object doInBackground() throws Exception {
                this.m_Output = adams.core.management.JMap.execute(fOptions, fPid);
                return null;
            }

            @Override
            protected void done() {
                TextDialog dialog = new TextDialog();
                dialog.setTitle("jmap (" + fPid + ")");
                dialog.setContent(this.m_Output);
                dialog.setLocationRelativeTo(JMap.this.getOwner());
                dialog.setVisible(true);
                super.done();
            }
        };
        worker.execute();
    }

    @Override
    public String getTitle() {
        return "JMap";
    }

    @Override
    public boolean isSingleton() {
        return false;
    }
}

